/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.imagemosaic.DateRangeVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class DateRangeVisitorTest {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final String UTC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private SimpleDateFormat df;
    private SimpleFeatureBuilder fb;

    @Before
    public void setup() {
        this.df = new SimpleDateFormat(UTC_PATTERN);
        this.df.setTimeZone(UTC_TIME_ZONE);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add("start", Date.class);
        tb.add("end", Date.class);
        tb.setName("test");
        SimpleFeatureType featureType = tb.buildFeatureType();
        this.fb = new SimpleFeatureBuilder(featureType);
    }

    SimpleFeature buildRangeFeature(String from, String to) throws ParseException {
        this.fb.add((Object)this.df.parse(from));
        this.fb.add((Object)this.df.parse(to));
        return this.fb.buildFeature(null);
    }

    @Test
    public void testSingleRange() throws ParseException {
        DateRangeVisitor visitor = new DateRangeVisitor("start", "end");
        visitor.visit(this.buildRangeFeature("2008-10-31T00:00:00.000Z", "2008-11-01T00:00:00.000Z"));
        Set range = visitor.getRange();
        Assert.assertEquals((long)1L, (long)range.size());
        Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z/2008-11-01T00:00:00.000Z/PT1S", range.iterator().next());
    }

    @Test
    public void testTwoRanges() throws ParseException {
        DateRangeVisitor visitor = new DateRangeVisitor("start", "end");
        visitor.visit(this.buildRangeFeature("2008-10-31T00:00:00.000Z", "2008-11-01T00:00:00.000Z"));
        visitor.visit(this.buildRangeFeature("2008-11-05T00:00:00.000Z", "2008-11-07T00:00:00.000Z"));
        ArrayList range = new ArrayList(visitor.getRange());
        Assert.assertEquals((long)2L, (long)range.size());
        Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z/2008-11-01T00:00:00.000Z/PT1S", range.get(0));
        Assert.assertEquals((Object)"2008-11-05T00:00:00.000Z/2008-11-07T00:00:00.000Z/PT1S", range.get(1));
    }

    @Test
    public void testThreeRangesOverlapFirst() throws ParseException {
        DateRangeVisitor visitor = new DateRangeVisitor("start", "end");
        visitor.visit(this.buildRangeFeature("2008-10-28T00:00:00.000Z", "2008-10-31T12:00:00.000Z"));
        visitor.visit(this.buildRangeFeature("2008-10-31T00:00:00.000Z", "2008-11-01T00:00:00.000Z"));
        visitor.visit(this.buildRangeFeature("2008-11-05T00:00:00.000Z", "2008-11-07T00:00:00.000Z"));
        ArrayList range = new ArrayList(visitor.getRange());
        Assert.assertEquals((long)2L, (long)range.size());
        Assert.assertEquals((Object)"2008-10-28T00:00:00.000Z/2008-11-01T00:00:00.000Z/PT1S", range.get(0));
        Assert.assertEquals((Object)"2008-11-05T00:00:00.000Z/2008-11-07T00:00:00.000Z/PT1S", range.get(1));
    }

    @Test
    public void testThreeRangesOverlapLast() throws ParseException {
        DateRangeVisitor visitor = new DateRangeVisitor("start", "end");
        visitor.visit(this.buildRangeFeature("2008-10-31T00:00:00.000Z", "2008-11-01T00:00:00.000Z"));
        visitor.visit(this.buildRangeFeature("2008-11-05T00:00:00.000Z", "2008-11-07T00:00:00.000Z"));
        visitor.visit(this.buildRangeFeature("2008-11-06T00:00:00.000Z", "2008-11-09T12:00:00.000Z"));
        ArrayList range = new ArrayList(visitor.getRange());
        Assert.assertEquals((long)2L, (long)range.size());
        Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z/2008-11-01T00:00:00.000Z/PT1S", range.get(0));
        Assert.assertEquals((Object)"2008-11-05T00:00:00.000Z/2008-11-09T12:00:00.000Z/PT1S", range.get(1));
    }

    @Test
    public void testFourRanges() throws ParseException {
        DateRangeVisitor visitor = new DateRangeVisitor("start", "end");
        visitor.visit(this.buildRangeFeature("2008-10-28T00:00:00.000Z", "2008-10-31T12:00:00.000Z"));
        visitor.visit(this.buildRangeFeature("2008-10-31T00:00:00.000Z", "2008-11-01T00:00:00.000Z"));
        visitor.visit(this.buildRangeFeature("2008-11-05T00:00:00.000Z", "2008-11-07T00:00:00.000Z"));
        visitor.visit(this.buildRangeFeature("2008-11-06T00:00:00.000Z", "2008-11-09T12:00:00.000Z"));
        ArrayList range = new ArrayList(visitor.getRange());
        Assert.assertEquals((long)2L, (long)range.size());
        Assert.assertEquals((Object)"2008-10-28T00:00:00.000Z/2008-11-01T00:00:00.000Z/PT1S", range.get(0));
        Assert.assertEquals((Object)"2008-11-05T00:00:00.000Z/2008-11-09T12:00:00.000Z/PT1S", range.get(1));
    }
}

