/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Properties;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicDirectoryWalker;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;

public class CatalogBuilderTest
extends Assert {
    private boolean hostnameDefined;

    @Before
    public void setup() {
        try {
            InetAddress.getLocalHost();
            this.hostnameDefined = true;
        }
        catch (Exception ex) {
            this.hostnameDefined = false;
        }
    }

    @Test
    public void catalogBuilderConfiguration() throws Exception {
        CatalogBuilderConfiguration c1 = new CatalogBuilderConfiguration();
        c1.setParameter("Name", "index");
        c1.setParameter("LocationAttribute", "location");
        c1.setParameter("AbsolutePath", "true");
        c1.setParameter("RootMosaicDirectory", TestData.file((Object)((Object)this), (String)"/rgb").toString());
        c1.setParameter("IndexingDirectories", TestData.file((Object)((Object)this), (String)"/rgb").toString());
        CatalogBuilderTest.assertNotNull((Object)c1.toString());
        CatalogBuilderConfiguration c2 = new CatalogBuilderConfiguration();
        c2.setParameter("Name", "index");
        c2.setParameter("LocationAttribute", "location");
        c2.setParameter("AbsolutePath", "true");
        c2.setParameter("RootMosaicDirectory", TestData.file((Object)((Object)this), (String)"/rgb").toString());
        c2.setParameter("IndexingDirectories", TestData.file((Object)((Object)this), (String)"/rgb").toString());
        CatalogBuilderTest.assertEquals((Object)c1, (Object)c2);
        CatalogBuilderTest.assertEquals((long)c1.hashCode(), (long)c2.hashCode());
        CatalogBuilderConfiguration c3 = c2.clone();
        CatalogBuilderTest.assertEquals((Object)c3, (Object)c2);
        CatalogBuilderTest.assertEquals((long)c3.hashCode(), (long)c2.hashCode());
        CatalogBuilderConfiguration c4 = new CatalogBuilderConfiguration();
        CatalogBuilderTest.assertNotNull((Object)c4.toString());
    }

    @Test
    @Ignore
    public void buildCatalog() throws FileNotFoundException, IOException {
        if (!this.hostnameDefined) {
            return;
        }
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue tileSize = AbstractGridFormat.SUGGESTED_TILE_SIZE.createValue();
        tileSize.setValue((Object)"128,128");
        CatalogBuilderConfiguration c1 = new CatalogBuilderConfiguration();
        c1.setParameter("Name", "shpindex");
        c1.setParameter("LocationAttribute", "location");
        c1.setParameter("AbsolutePath", "false");
        c1.setParameter("RootMosaicDirectory", TestData.file((Object)((Object)this), (String)"/overview/0").toString());
        c1.setParameter("IndexingDirectories", TestData.file((Object)((Object)this), (String)"/overview/0").toString());
        CatalogBuilderTest.assertNotNull((Object)c1.toString());
        ImageMosaicEventHandlers eventHandler = new ImageMosaicEventHandlers();
        ImageMosaicConfigHandler catalogHandler = new ImageMosaicConfigHandler(c1, eventHandler);
        ImageMosaicDirectoryWalker builder = new ImageMosaicDirectoryWalker(catalogHandler, eventHandler);
        eventHandler.addProcessingEventListener((ImageMosaicEventHandlers.ProcessingEventListener)new CatalogBuilderListener());
        builder.run();
        File relativeMosaic = TestData.file((Object)((Object)this), (String)("/overview/" + c1.getParameter("Name") + ".shp"));
        CatalogBuilderTest.assertTrue((boolean)relativeMosaic.exists());
        CatalogBuilderTest.assertTrue((boolean)new ImageMosaicFormat().accepts((Object)relativeMosaic));
        ImageMosaicReader reader = new ImageMosaicReader((Object)relativeMosaic);
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        Dimension dim = new Dimension();
        dim.setSize((double)reader.getOriginalGridRange().getSpan(0) / 2.0, (double)reader.getOriginalGridRange().getSpan(1) / 2.0);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{gg, useJai, tileSize});
        Assert.assertNotNull((Object)coverage);
        PlanarImage.wrapRenderedImage((RenderedImage)coverage.getRenderedImage()).getTiles();
        Properties props = new Properties();
        String c1IndexerProps = "/overview/" + c1.getParameter("Name") + ".properties";
        try (InputStream in = TestData.openStream((Object)((Object)this), (String)c1IndexerProps);){
            CatalogBuilderTest.assertNotNull((String)"unable to find mosaic properties file", (Object)in);
            props.load(in);
            CatalogBuilderTest.assertTrue((boolean)props.containsKey("Caching"));
            CatalogBuilderTest.assertTrue((boolean)props.getProperty("Caching").equalsIgnoreCase("false"));
        }
        coverage.dispose(true);
        reader.dispose();
        CatalogBuilderConfiguration c2 = new CatalogBuilderConfiguration();
        c2.setParameter("Name", "shpindex_absolute");
        c2.setParameter("LocationAttribute", "location");
        c2.setParameter("AbsolutePath", "true");
        c2.setParameter("Caching", "true");
        c2.setParameter("RootMosaicDirectory", TestData.file((Object)((Object)this), (String)"/overview").toString());
        c2.setParameter("IndexingDirectories", TestData.file((Object)((Object)this), (String)"/overview").toString());
        CatalogBuilderTest.assertNotNull((Object)c2.toString());
        ImageMosaicEventHandlers eventHandler2 = new ImageMosaicEventHandlers();
        ImageMosaicConfigHandler catalogHandler2 = new ImageMosaicConfigHandler(c2, eventHandler);
        builder = new ImageMosaicDirectoryWalker(catalogHandler2, eventHandler);
        eventHandler2.addProcessingEventListener((ImageMosaicEventHandlers.ProcessingEventListener)new CatalogBuilderListener());
        builder.run();
        File absoluteMosaic = TestData.file((Object)((Object)this), (String)("/overview/" + c2.getParameter("Name") + ".shp"));
        CatalogBuilderTest.assertTrue((boolean)absoluteMosaic.exists());
        props = new Properties();
        try (InputStream in = TestData.openStream((Object)((Object)this), (String)("/overview/" + c2.getParameter("Name") + ".properties"));){
            CatalogBuilderTest.assertNotNull((String)"unable to find mosaic properties file", (Object)in);
            props.load(in);
            CatalogBuilderTest.assertTrue((boolean)props.containsKey("Caching"));
            CatalogBuilderTest.assertTrue((boolean)props.getProperty("Caching").equalsIgnoreCase("true"));
        }
        CatalogBuilderTest.assertTrue((boolean)new ImageMosaicFormat().accepts((Object)absoluteMosaic));
        reader = new ImageMosaicReader((Object)absoluteMosaic);
        gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        envelope = reader.getOriginalEnvelope();
        dim = new Dimension();
        dim.setSize((double)reader.getOriginalGridRange().getSpan(0) / 2.0, (double)reader.getOriginalGridRange().getSpan(1) / 2.0);
        rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
        coverage = reader.read(new GeneralParameterValue[]{gg, useJai, tileSize});
        Assert.assertNotNull((Object)coverage);
        PlanarImage.wrapRenderedImage((RenderedImage)coverage.getRenderedImage()).getTiles();
        coverage.dispose(true);
        reader.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void buildCachingIndex() throws FileNotFoundException, IOException {
        GranuleCatalog catalog;
        String value;
        FileInputStream inStream;
        File propertiesFile;
        File relativeMosaic;
        ImageMosaicConfigHandler catalogHandler;
        ImageMosaicEventHandlers eventHandler2;
        if (!this.hostnameDefined) {
            return;
        }
        ImageMosaicDirectoryWalker builder = null;
        ImageMosaicReader reader = null;
        CatalogBuilderConfiguration c1 = new CatalogBuilderConfiguration();
        c1.setParameter("Name", "shpindex");
        c1.setParameter("LocationAttribute", "location");
        c1.setParameter("AbsolutePath", "false");
        c1.setParameter("RootMosaicDirectory", TestData.file((Object)((Object)this), (String)"/caching").toString());
        c1.setParameter("IndexingDirectories", TestData.file((Object)((Object)this), (String)"/caching").toString());
        Properties prop = new Properties();
        try {
            c1.setParameter("Caching", "false");
            eventHandler2 = new ImageMosaicEventHandlers();
            catalogHandler = new ImageMosaicConfigHandler(c1, eventHandler2);
            builder = new ImageMosaicDirectoryWalker(catalogHandler, eventHandler2);
            eventHandler2.addProcessingEventListener((ImageMosaicEventHandlers.ProcessingEventListener)new CatalogBuilderListener());
            builder.run();
            relativeMosaic = TestData.file((Object)((Object)this), (String)("/caching/" + c1.getParameter("Name") + ".shp"));
            propertiesFile = TestData.file((Object)((Object)this), (String)("/caching/" + c1.getParameter("Name") + ".properties"));
            CatalogBuilderTest.assertTrue((boolean)relativeMosaic.exists());
            inStream = new FileInputStream(propertiesFile);
            try {
                prop.load(inStream);
            }
            finally {
                ((InputStream)inStream).close();
            }
            value = prop.getProperty("Caching");
            CatalogBuilderTest.assertNotNull((Object)value);
            CatalogBuilderTest.assertEquals((Object)"false", (Object)value.toLowerCase());
            CatalogBuilderTest.assertTrue((boolean)new ImageMosaicFormat().accepts((Object)relativeMosaic));
            reader = new ImageMosaicReader((Object)relativeMosaic);
            catalog = reader.getRasterManager((String)reader.defaultName).granuleCatalog;
            CatalogBuilderTest.assertTrue((boolean)catalog.getClass().toString().endsWith("GTDataStoreGranuleCatalog"));
        }
        finally {
            try {
                if (reader != null) {
                    reader.dispose();
                }
            }
            catch (Throwable eventHandler2) {}
        }
        try {
            c1.setParameter("Caching", "true");
            eventHandler2 = new ImageMosaicEventHandlers();
            catalogHandler = new ImageMosaicConfigHandler(c1, eventHandler2);
            builder = new ImageMosaicDirectoryWalker(catalogHandler, eventHandler2);
            eventHandler2.addProcessingEventListener((ImageMosaicEventHandlers.ProcessingEventListener)new CatalogBuilderListener());
            builder.run();
            relativeMosaic = TestData.file((Object)((Object)this), (String)("/caching/" + c1.getParameter("Name") + ".shp"));
            propertiesFile = TestData.file((Object)((Object)this), (String)("/caching/" + c1.getParameter("Name") + ".properties"));
            inStream = new FileInputStream(propertiesFile);
            try {
                prop.load(inStream);
            }
            finally {
                ((InputStream)inStream).close();
            }
            value = prop.getProperty("Caching");
            CatalogBuilderTest.assertNotNull((Object)value);
            CatalogBuilderTest.assertEquals((Object)"true", (Object)value.toLowerCase());
            CatalogBuilderTest.assertTrue((boolean)relativeMosaic.exists());
            CatalogBuilderTest.assertTrue((boolean)new ImageMosaicFormat().accepts((Object)relativeMosaic));
            reader = new ImageMosaicReader((Object)relativeMosaic);
            catalog = reader.getRasterManager((String)reader.defaultName).granuleCatalog;
            CatalogBuilderTest.assertTrue((boolean)catalog.getClass().toString().endsWith("STRTreeGranuleCatalog"));
        }
        finally {
            try {
                if (reader != null) {
                    reader.dispose();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private final class CatalogBuilderListener
    extends ImageMosaicEventHandlers.ProcessingEventListener {
        private CatalogBuilderListener() {
        }

        public void exceptionOccurred(ImageMosaicEventHandlers.ExceptionEvent event) {
            throw new RuntimeException(event.getException());
        }

        public void getNotification(ImageMosaicEventHandlers.ProcessingEvent event) {
        }
    }
}

