/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.granulehandler;

import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.granulehandler.GranuleHandler;
import org.geotools.gce.imagemosaic.granulehandler.GranuleHandlingException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.GeometryCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class ReprojectingGranuleHandler
implements GranuleHandler {
    /*
     * Unable to fully structure code
     */
    @Override
    public void handleGranule(Object source, GridCoverage2DReader inputReader, SimpleFeature targetFeature, SimpleFeatureType targetFeatureType, SimpleFeature inputFeature, SimpleFeatureType inputFeatureType, MosaicConfigurationBean mosaicConfiguration) throws GranuleHandlingException {
        targetCRS = mosaicConfiguration.getCrs();
        if (inputFeature instanceof StructuredGridCoverage2DReader) {
            this.handleStructuredGranule(source, inputReader, targetFeature, targetFeatureType, inputFeature, inputFeatureType, mosaicConfiguration);
        } else {
            coverageEnvelope = inputReader.getOriginalEnvelope();
            coverageCRS = inputReader.getCoordinateReferenceSystem();
            finalEnvelope = new ReferencedEnvelope((Envelope)coverageEnvelope);
            geometry = null;
            if (!CRS.equalsIgnoreMetadata((Object)targetCRS, (Object)coverageCRS)) {
                try {
                    geometry = Utils.reprojectEnvelopeToGeometry(finalEnvelope, targetCRS, null);
                    if (geometry == null) {
                        throw new GranuleHandlingException("Reprojection of source envelope failed, got back a null one " + String.valueOf(finalEnvelope));
                    }
                    if (!(geometry instanceof GeometryCollection)) ** GOTO lbl20
                    geometry = geometry.getGeometryN(0);
                }
                catch (FactoryException | TransformException e) {
                    throw new GranuleHandlingException("Unable to reproject incoming granule, but target and granule CRS differ so we can't continue", (Exception)e);
                }
            } else {
                geometry = JTS.toGeometry((ReferencedEnvelope)finalEnvelope);
            }
lbl20:
            // 3 sources

            targetFeature.setAttribute(targetFeatureType.getGeometryDescriptor().getName(), (Object)geometry);
        }
    }
}

