/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.granulecollector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.gce.imagemosaic.MergeBehavior;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.granulecollector.DefaultSubmosaicProducer;
import org.geotools.gce.imagemosaic.granulecollector.SubmosaicProducer;
import org.geotools.gce.imagemosaic.granulecollector.SubmosaicProducerFactory;
import org.opengis.filter.And;
import org.opengis.filter.Filter;

public class DefaultSubmosaicProducerFactory
implements SubmosaicProducerFactory {
    @Override
    public List<SubmosaicProducer> createProducers(RasterLayerRequest request, RasterManager rasterManager, RasterLayerResponse response, boolean dryRun) {
        Map<String, List> requestedAdditionalDomains;
        ArrayList<SubmosaicProducer> defaultSubmosaicProducers = new ArrayList<SubmosaicProducer>();
        MergeBehavior mergeBehavior = request.getMergeBehavior();
        if (mergeBehavior.equals((Object)MergeBehavior.STACK) && !(requestedAdditionalDomains = request.getRequestedAdditionalDomains()).isEmpty()) {
            And andFilter;
            Set<Map.Entry<String, List>> entries = requestedAdditionalDomains.entrySet();
            this.checkMultipleSelection(entries);
            Map.Entry<String, List> multipleSelectionEntry = null;
            ArrayList<Filter> filters = new ArrayList<Filter>(entries.size());
            for (Map.Entry<String, List> entry : entries) {
                if (entry.getValue().size() > 1) {
                    multipleSelectionEntry = entry;
                    continue;
                }
                String domainName = entry.getKey() + "_DOMAIN";
                filters.add(rasterManager.getDomainsManager().createFilter(domainName, Arrays.asList(entry.getValue())));
            }
            And and = andFilter = filters.isEmpty() ? null : FeatureUtilities.DEFAULT_FILTER_FACTORY.and(filters);
            if (multipleSelectionEntry == null) {
                defaultSubmosaicProducers.add(new DefaultSubmosaicProducer(response, (Filter)andFilter, dryRun));
            } else {
                String domainName = (String)multipleSelectionEntry.getKey() + "_DOMAIN";
                List values = multipleSelectionEntry.getValue();
                for (Object o : values) {
                    Filter valueFilter = rasterManager.getDomainsManager().createFilter(domainName, Arrays.asList(o));
                    Filter combinedFilter = andFilter == null ? valueFilter : FeatureUtilities.DEFAULT_FILTER_FACTORY.and((Filter)andFilter, valueFilter);
                    defaultSubmosaicProducers.add(new DefaultSubmosaicProducer(response, combinedFilter, dryRun));
                }
            }
        }
        if (defaultSubmosaicProducers.isEmpty()) {
            defaultSubmosaicProducers.add(new DefaultSubmosaicProducer(response, (Filter)Filter.INCLUDE, dryRun));
        }
        return defaultSubmosaicProducers;
    }

    private void checkMultipleSelection(Set<Map.Entry<String, List>> entries) {
        int multipleDimensionsSelections = 0;
        for (Map.Entry<String, List> entry : entries) {
            if (entry.getValue().size() <= 1 || ++multipleDimensionsSelections <= 1) continue;
            throw new IllegalStateException("Unable to handle dimensions stacking for more than 1 dimension");
        }
    }
}

