/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProvider;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBeans;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.util.factory.Hints;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;

public abstract class GranuleCatalog {
    protected final Hints hints;
    protected final CatalogConfigurationBeans configurations;
    protected MultiLevelROIProvider multiScaleROIProvider;

    public GranuleCatalog(Hints hints, CatalogConfigurationBeans configurations) {
        this.hints = hints;
        this.configurations = configurations;
    }

    public void addGranule(String typeName, SimpleFeature granule, Transaction transaction) throws IOException {
        this.addGranules(typeName, Collections.singleton(granule), transaction);
    }

    public abstract void addGranules(String var1, Collection<SimpleFeature> var2, Transaction var3) throws IOException;

    public abstract void computeAggregateFunction(Query var1, FeatureCalc var2) throws IOException;

    public abstract void createType(String var1, String var2, String var3) throws IOException, SchemaException;

    public abstract void createType(SimpleFeatureType var1) throws IOException;

    public abstract void createType(String var1, String var2) throws SchemaException, IOException;

    public abstract void dispose();

    public abstract BoundingBox getBounds(String var1);

    public BoundingBox getBounds(String typeName, Transaction t) {
        if (t == null || t == Transaction.AUTO_COMMIT) {
            return this.getBounds(typeName);
        }
        throw new IllegalArgumentException("This implementation of GranuleCatalog does not override getBounds(t, t), the default implementation can only work with the auto commit transaction");
    }

    public abstract SimpleFeatureCollection getGranules(Query var1) throws IOException;

    public SimpleFeatureCollection getGranules(Query q, Transaction t) throws IOException {
        if (t == null || t == Transaction.AUTO_COMMIT) {
            return this.getGranules(q);
        }
        throw new IllegalArgumentException("This implementation of GranuleCatalog does not override getGranules(q, t), the default implementation can only work with the auto commit transaction");
    }

    public abstract int getGranulesCount(Query var1) throws IOException;

    public abstract void getGranuleDescriptors(Query var1, GranuleCatalogVisitor var2) throws IOException;

    public abstract QueryCapabilities getQueryCapabilities(String var1);

    public abstract SimpleFeatureType getType(String var1) throws IOException;

    public abstract void removeType(String var1) throws IOException;

    @Deprecated
    public abstract int removeGranules(Query var1);

    public int removeGranules(Query query, Transaction transaction) {
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            return this.removeGranules(query);
        }
        throw new IllegalArgumentException("This implementation of GranuleCatalog does not override removeGranules(q, t), the default implementation can only work with the auto commit transaction");
    }

    public abstract String[] getTypeNames();

    protected Query mergeHints(Query q) {
        if (this.hints == null || this.hints.isEmpty()) {
            return q;
        }
        Query clone = new Query(q);
        Hints hints = clone.getHints();
        if (hints == null || hints.isEmpty()) {
            clone.setHints(this.hints);
        } else {
            for (Map.Entry entry : this.hints.entrySet()) {
                if (hints.containsKey(entry.getKey())) continue;
                hints.put(entry.getKey(), entry.getValue());
            }
        }
        return clone;
    }

    public void setMultiScaleROIProvider(MultiLevelROIProvider footprintProvider) {
        this.multiScaleROIProvider = footprintProvider;
    }

    protected MultiLevelROI getGranuleFootprint(SimpleFeature sf) {
        if (this.multiScaleROIProvider != null) {
            try {
                MultiLevelROI roi = this.multiScaleROIProvider.getMultiScaleROI(sf);
                return roi;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load the footprint for granule: " + String.valueOf(sf), e);
            }
        }
        return null;
    }

    public List<File> getFootprintFiles(SimpleFeature sf) throws IOException {
        if (this.multiScaleROIProvider != null) {
            return this.multiScaleROIProvider.getFootprintFiles(sf);
        }
        return Collections.emptyList();
    }

    public abstract void drop() throws IOException;

    protected CatalogConfigurationBeans getConfigurations() {
        return this.configurations;
    }

    protected abstract String getParentLocation();

    public Hints getHints() {
        return this.hints;
    }
}

