/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.footprint.FootprintGeometryProvider;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.PropertyName;

class GTDataStoreFootprintProvider
implements FootprintGeometryProvider {
    static final Logger LOGGER = Logging.getLogger(GTDataStoreFootprintProvider.class);
    private SimpleFeatureSource featureSource;
    private Filter filter;
    private DataStore store;

    public GTDataStoreFootprintProvider(Map<String, Serializable> params, String typeName, Filter filter) throws IOException {
        this.store = DataStoreFinder.getDataStore(params);
        if (this.store == null) {
            throw new IOException("Coould not create footprint data store from params: " + String.valueOf(params));
        }
        this.featureSource = typeName != null ? this.store.getFeatureSource(typeName) : this.store.getFeatureSource("footprints");
        this.filter = filter;
    }

    public Geometry getFootprint(SimpleFeature feature) throws IOException {
        Filter localFilter = (Filter)this.filter.accept((FilterVisitor)new GranuleFilterVisitor(feature), null);
        SimpleFeatureCollection fc = this.featureSource.getFeatures(localFilter);
        try (SimpleFeatureIterator fi = fc.features();){
            Geometry result = null;
            if (fi.hasNext()) {
                SimpleFeature sf = (SimpleFeature)fi.next();
                result = (Geometry)sf.getDefaultGeometry();
                if (fi.hasNext()) {
                    throw new IOException("The filter " + String.valueOf(localFilter) + " matched more than one footprint record, in particular, it matched " + fc.size() + ", the first match is: " + String.valueOf(sf));
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Returning footprint " + String.valueOf(result) + " for granule " + String.valueOf(feature));
            }
            Geometry geometry = result;
            return geometry;
        }
    }

    public void dispose() {
        this.store.dispose();
    }

    public class GranuleFilterVisitor
    extends DuplicatingFilterVisitor
    implements FilterVisitor {
        private static final String GRANULE_PREFIX = "granule/";
        private SimpleFeature feature;

        public GranuleFilterVisitor(SimpleFeature feature) {
            this.feature = feature;
        }

        public Object visit(PropertyName expression, Object extraData) {
            String pname = expression.getPropertyName();
            if (pname != null && pname.startsWith(GRANULE_PREFIX)) {
                String attName = pname.substring(GRANULE_PREFIX.length());
                return this.ff.literal(this.feature.getAttribute(attName));
            }
            return super.visit(expression, extraData);
        }
    }
}

