/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.util.NoSuchElementException;
import java.util.function.Function;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureIterator;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.Envelope;

class BoundsFeatureCollection
extends DecoratingSimpleFeatureCollection {
    private final Function<SimpleFeature, GranuleDescriptor> granuleMapper;

    protected BoundsFeatureCollection(SimpleFeatureCollection delegate, Function<SimpleFeature, GranuleDescriptor> granuleMapper) {
        super(delegate);
        this.granuleMapper = granuleMapper;
    }

    public SimpleFeatureIterator features() {
        return new BoundsFeatureIterator(this.delegate.features());
    }

    class BoundsFeatureIterator
    extends DecoratingSimpleFeatureIterator {
        public BoundsFeatureIterator(SimpleFeatureIterator iterator) {
            super(iterator);
        }

        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature sf = (SimpleFeature)super.next();
            GranuleDescriptor descriptor = BoundsFeatureCollection.this.granuleMapper.apply(sf);
            ReferencedEnvelope re = ReferencedEnvelope.reference((Envelope)descriptor.getGranuleEnvelope());
            sf.getUserData().put("nativeBounds", re);
            return sf;
        }
    }
}

