/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.jaiext.utilities.ImageLayout2;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import org.geotools.image.ImageWorker;

public enum MergeBehavior {
    STACK{

        @Override
        public RenderedImage process(RenderedImage[] sources, double[] backgroundValues, double[][] inputThreshold, PlanarImage[] sourceAlpha, ROI[] sourceROI, MosaicType mosaicType, RenderingHints hints) {
            int i;
            if (sources.length == 1) {
                return FLAT.process(sources, backgroundValues, inputThreshold, sourceAlpha, sourceROI, mosaicType, hints);
            }
            Rectangle union = new Rectangle(PlanarImage.wrapRenderedImage((RenderedImage)sources[0]).getBounds());
            boolean performMosaic = false;
            for (int i2 = 1; i2 < sources.length; ++i2) {
                ROI[] currentExtent = PlanarImage.wrapRenderedImage((RenderedImage)sources[0]).getBounds();
                if (currentExtent.equals(union)) continue;
                performMosaic = true;
                union = union.union((Rectangle)currentExtent);
            }
            boolean border = true;
            if (sourceROI != null) {
                for (ROI roi : sourceROI) {
                    if (roi == null) continue;
                    border = false;
                    break;
                }
            }
            if (performMosaic) {
                BorderExtenderConstant borderExtenderConstant = new BorderExtenderConstant(backgroundValues);
                for (i = 0; i < sources.length; ++i) {
                    RenderingHints localHints;
                    if (border) {
                        if (PlanarImage.wrapRenderedImage((RenderedImage)sources[i]).getBounds().equals(union)) continue;
                        Rectangle currentExtent = PlanarImage.wrapRenderedImage((RenderedImage)sources[0]).getBounds();
                        ImageWorker worker = new ImageWorker(sources[i]).setRenderingHints(hints);
                        worker.border(union.x - currentExtent.x, union.x + union.width - currentExtent.x - currentExtent.width, union.y - currentExtent.y, union.y + union.height - currentExtent.y - currentExtent.height, (BorderExtender)borderExtenderConstant);
                        sources[i] = worker.getRenderedImage();
                        continue;
                    }
                    ImageLayout layout = (ImageLayout)(hints != null ? hints.get(JAI.KEY_IMAGE_LAYOUT) : new ImageLayout2());
                    layout.setWidth(union.width).setHeight(union.height).setMinX(union.x).setMinY(union.y);
                    if (hints != null) {
                        localHints = (RenderingHints)hints.clone();
                        localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
                    } else {
                        localHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
                    }
                    return new ImageWorker(localHints).setBackground(backgroundValues).mosaic(sources, MosaicDescriptor.MOSAIC_TYPE_OVERLAY, sourceAlpha, sourceROI, inputThreshold, null).getRenderedImage();
                }
            }
            ImageWorker worker = new ImageWorker(sources[0]);
            worker.setRenderingHints(hints);
            for (i = 1; i < sources.length; ++i) {
                worker.addBand(sources[i], false);
            }
            return worker.getRenderedImage();
        }
    }
    ,
    FLAT{

        @Override
        public RenderedImage process(RenderedImage[] sources, double[] backgroundValues, double[][] inputThreshold, PlanarImage[] sourceAlpha, ROI[] sourceROI, MosaicType mosaicType, RenderingHints localHints) {
            return new ImageWorker(localHints).setBackground(backgroundValues).mosaic(sources, mosaicType, sourceAlpha, sourceROI, inputThreshold, null).getRenderedImage();
        }
    };


    public abstract RenderedImage process(RenderedImage[] var1, double[] var2, double[][] var3, PlanarImage[] var4, ROI[] var5, MosaicType var6, RenderingHints var7);

    public static MergeBehavior getDefault() {
        return FLAT;
    }

    public static String[] valuesAsStrings() {
        MergeBehavior[] values = MergeBehavior.values();
        String[] valuesS = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            valuesS[i] = values[i].toString();
        }
        return valuesS;
    }
}

