/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.util.logging.Logging;

public class ImageMosaicEventHandlers {
    static final Logger LOGGER = Logging.getLogger(ImageMosaicEventHandlers.class);
    protected List<ProcessingEventListener> notificationListeners = new CopyOnWriteArrayList<ProcessingEventListener>();
    protected boolean sendDelayedMessages = false;

    public final void addProcessingEventListener(ProcessingEventListener listener) {
        this.notificationListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(Level level, String inMessage, double percentage) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, inMessage);
        }
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(inMessage);
            ProcessingEvent evt = new ProcessingEvent(this, message.toString(), percentage);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFileEvent(Level level, File file, boolean ingested, String inMessage, double percentage) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, inMessage);
        }
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(inMessage);
            FileProcessingEvent evt = new FileProcessingEvent(this, file, ingested, message.toString(), percentage);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireUrlEvent(Level level, URL url, boolean ingested, String inMessage, double percentage) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, inMessage);
        }
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(inMessage);
            URLProcessingEvent evt = new URLProcessingEvent(this, url, ingested, message.toString(), percentage);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireURIEvent(Level level, URI uri, boolean ingested, String inMessage, double percentage) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, inMessage);
        }
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(inMessage);
            URIProcessingEvent evt = new URIProcessingEvent(this, uri, ingested, message.toString(), percentage);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireException(Exception ex) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.fireException(Utils.getMessageFromException(ex), -1.0, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireException(String string, double percentage, Exception ex) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(string);
            ExceptionEvent evt = new ExceptionEvent(this, string, percentage, ex);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    public boolean isSendDelayedMessages() {
        return this.sendDelayedMessages;
    }

    public void setSendDelayedMessages(boolean sendDelayedMessages) {
        this.sendDelayedMessages = sendDelayedMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllProcessingEventListeners() {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.notificationListeners.clear();
        }
    }

    public void removeProcessingEventListener(ProcessingEventListener listener) {
        this.notificationListeners.remove(listener);
    }

    private void sendEvent(ProgressEventDispatchThreadEventLauncher eventLauncher) {
        if (this.sendDelayedMessages) {
            SwingUtilities.invokeLater(eventLauncher);
        } else {
            eventLauncher.run();
        }
    }

    protected static final class ProgressEventDispatchThreadEventLauncher
    implements Runnable {
        private ProcessingEvent event;
        private Object[] listeners;

        ProgressEventDispatchThreadEventLauncher() {
        }

        synchronized void setEvent(ProcessingEvent evt, Object[] listeners) {
            if (listeners == null || evt == null) {
                throw new NullPointerException("Input argumentBuilder cannot be null");
            }
            this.listeners = listeners;
            this.event = evt;
        }

        @Override
        public void run() {
            if (this.event instanceof ExceptionEvent) {
                for (Object o : this.listeners) {
                    ((ProcessingEventListener)o).exceptionOccurred((ExceptionEvent)this.event);
                }
            } else {
                for (Object listener : this.listeners) {
                    ((ProcessingEventListener)listener).getNotification(this.event);
                }
            }
        }
    }

    public static final class ExceptionEvent
    extends ProcessingEvent {
        private static final long serialVersionUID = 2272452028229922551L;
        private Exception exception;

        public ExceptionEvent(Object source, String message, double percentage, Exception exception) {
            super(source, message, percentage);
            this.exception = exception;
        }

        public ExceptionEvent(Object source, Exception exception) {
            super(source, Utils.getMessageFromException(exception), -1.0);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class URIProcessingEvent
    extends ProcessingEvent {
        private URI uri;
        private boolean ingested;

        public URIProcessingEvent(Object source, URI uri, boolean ingested, String message, double percentage) {
            super(source, message, percentage);
            this.uri = uri;
            this.ingested = ingested;
        }

        public URI getURI() {
            return this.uri;
        }

        public boolean isIngested() {
            return this.ingested;
        }
    }

    public static class URLProcessingEvent
    extends ProcessingEvent {
        private URL url;
        private boolean ingested;

        public URLProcessingEvent(Object source, URL url, boolean ingested, String message, double percentage) {
            super(source, message, percentage);
            this.url = url;
            this.ingested = ingested;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean isIngested() {
            return this.ingested;
        }
    }

    public static class FileProcessingEvent
    extends ProcessingEvent {
        private File file;
        private boolean ingested;

        public FileProcessingEvent(Object source, File file, boolean ingested, String message, double percentage) {
            super(source, message, percentage);
            this.file = file;
            this.ingested = ingested;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isIngested() {
            return this.ingested;
        }
    }

    public static class ProcessingEvent
    extends EventObject {
        private static final long serialVersionUID = 6930580659705360225L;
        private String message = null;
        private double percentage = 0.0;

        public ProcessingEvent(Object source, String message, double percentage) {
            super(source);
            this.message = message;
            this.percentage = percentage;
        }

        public double getPercentage() {
            return this.percentage;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static abstract class ProcessingEventListener
    implements EventListener {
        public abstract void getNotification(ProcessingEvent var1);

        public abstract void exceptionOccurred(ExceptionEvent var1);
    }
}

