/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal.srp;

import it.geosolutions.imageio.plugins.srp.SRPImageReaderSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.coverageio.gdal.BaseGDALGridFormat;
import org.geotools.coverageio.gdal.srp.SRPReader;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public final class SRPFormat
extends BaseGDALGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(SRPFormat.class);
    private static BaseGDALGridFormat.InfoWrapper INFO = new BaseGDALGridFormat.InfoWrapper("ASRP/USRP Coverage Format", "SRP");

    public SRPFormat() {
        super((ImageReaderSpi)new SRPImageReaderSpi());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating a new SRPFormat.");
        }
        this.setInfo();
    }

    @Override
    protected void setInfo() {
        this.setInfo(INFO);
    }

    public SRPReader getReader(Object source, Hints hints) {
        try {
            return new SRPReader(source, hints);
        }
        catch (DataSourceException | MismatchedDimensionException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
    }
}

