/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal.vrt;

import it.geosolutions.imageio.plugins.vrt.VRTImageReaderSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.coverageio.gdal.BaseGDALGridFormat;
import org.geotools.coverageio.gdal.vrt.VRTReader;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public final class VRTFormat
extends BaseGDALGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(VRTFormat.class);
    private static BaseGDALGridFormat.InfoWrapper INFO = new BaseGDALGridFormat.InfoWrapper("Virtual (VRT) Format", "VRT");

    public VRTFormat() {
        super((ImageReaderSpi)new VRTImageReaderSpi());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating a new VRTFormat.");
        }
        this.setInfo();
    }

    @Override
    protected void setInfo() {
        this.setInfo(INFO);
    }

    public VRTReader getReader(Object source, Hints hints) {
        try {
            return new VRTReader(source, hints);
        }
        catch (DataSourceException | MismatchedDimensionException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
    }
}

