/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal.rpftoc;

import it.geosolutions.imageio.plugins.rpftoc.RPFTOCImageReaderSpi;
import java.io.File;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.data.DataSourceException;
import org.geotools.coverageio.gdal.BaseGDALGridCoverage2DReader;
import org.geotools.coverageio.gdal.rpftoc.RPFTOCFormat;
import org.geotools.util.factory.Hints;

public final class RPFTOCReader
extends BaseGDALGridCoverage2DReader
implements GridCoverageReader {
    private static final String worldFileExt = "";

    public RPFTOCReader(Object input) throws DataSourceException {
        this(input, null);
    }

    public RPFTOCReader(Object input, Hints hints) throws DataSourceException {
        super(input, hints, worldFileExt, (ImageReaderSpi)new RPFTOCImageReaderSpi());
    }

    public Format getFormat() {
        return new RPFTOCFormat();
    }

    @Override
    public String getCoverageName() {
        String retVal = "RPFTOC Coverage";
        if (!super.getCoverageName().equals("A")) {
            retVal = super.getCoverageName();
        } else {
            retVal = "RPFTOC Coverage";
            for (File oFile = super.getInputFile().getParentFile(); oFile != null; oFile = oFile.getParentFile()) {
                String sName = oFile.getName();
                if (sName.toUpperCase().equals("RPF")) continue;
                retVal = sName;
                break;
            }
        }
        return retVal;
    }
}

