/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal.erdasimg;

import it.geosolutions.imageio.plugins.erdasimg.ErdasImgImageReaderSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.coverageio.gdal.BaseGDALGridFormat;
import org.geotools.coverageio.gdal.erdasimg.ErdasImgReader;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public final class ErdasImgFormat
extends BaseGDALGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(ErdasImgFormat.class);
    private static BaseGDALGridFormat.InfoWrapper INFO = new BaseGDALGridFormat.InfoWrapper("Erdas Imagine Coverage Format", "ERDASImg");

    public ErdasImgFormat() {
        super((ImageReaderSpi)new ErdasImgImageReaderSpi());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating a new ErdasImgFormat.");
        }
        this.setInfo();
    }

    @Override
    protected void setInfo() {
        this.setInfo(INFO);
    }

    public ErdasImgReader getReader(Object source, Hints hints) {
        try {
            return new ErdasImgReader(source, hints);
        }
        catch (DataSourceException | MismatchedDimensionException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
    }
}

