/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio;

import java.io.File;
import org.geotools.api.metadata.extent.GeographicBoundingBox;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.Utilities;

class GridCoverageUtilities {
    static final String DEFAULT_WORLDFILE_EXT = ".wld";
    static final char SEPARATOR = File.separatorChar;
    static final String IMAGEREAD = "ImageRead";
    static final String IMAGEREADMT = "ImageReadMT";

    private GridCoverageUtilities() {
    }

    public static ReferencedEnvelope getReferencedEnvelopeFromGeographicBoundingBox(GeographicBoundingBox geographicBBox) {
        Utilities.ensureNonNull((String)"GeographicBoundingBox", (Object)geographicBBox);
        return new ReferencedEnvelope(geographicBBox.getEastBoundLongitude(), geographicBBox.getWestBoundLongitude(), geographicBBox.getSouthBoundLatitude(), geographicBBox.getNorthBoundLatitude(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }
}

