/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal.dted;

import it.geosolutions.imageio.plugins.dted.DTEDImageReaderSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverageio.gdal.BaseGDALGridFormat;
import org.geotools.coverageio.gdal.dted.DTEDReader;
import org.geotools.data.DataSourceException;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.MismatchedDimensionException;

public final class DTEDFormat
extends BaseGDALGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(DTEDFormat.class);
    private static final BaseGDALGridFormat.InfoWrapper INFO = new BaseGDALGridFormat.InfoWrapper("DTED Coverage Format", "DTED");

    public DTEDFormat() {
        super((ImageReaderSpi)new DTEDImageReaderSpi());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating a new DTEDFormat.");
        }
        this.setInfo();
    }

    @Override
    protected void setInfo() {
        this.setInfo(INFO);
    }

    public DTEDReader getReader(Object source, Hints hints) {
        try {
            return new DTEDReader(source, hints);
        }
        catch (MismatchedDimensionException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
        catch (DataSourceException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
    }
}

