/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal.aig;

import it.geosolutions.imageio.plugins.arcbinarygrid.ArcBinaryGridImageReaderSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverageio.gdal.BaseGDALGridFormat;
import org.geotools.coverageio.gdal.aig.AIGReader;
import org.geotools.data.DataSourceException;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.MismatchedDimensionException;

public final class AIGFormat
extends BaseGDALGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(AIGFormat.class);
    private static final BaseGDALGridFormat.InfoWrapper INFO = new BaseGDALGridFormat.InfoWrapper("Arc/Info Binary Grid (AIG) Coverage Format", "AIG");

    public AIGFormat() {
        super((ImageReaderSpi)new ArcBinaryGridImageReaderSpi());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating a new AIGFormat.");
        }
        this.setInfo();
    }

    @Override
    protected void setInfo() {
        this.setInfo(INFO);
    }

    public AIGReader getReader(Object source, Hints hints) {
        try {
            return new AIGReader(source, hints);
        }
        catch (MismatchedDimensionException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
        catch (DataSourceException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
    }
}

