/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio;

import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.footprint.FootprintBehavior;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.coverageio.RasterLayerRequest;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

class RasterLayerResponse {
    private static final Logger LOGGER = Logging.getLogger(RasterLayerResponse.class);
    private GridCoverage gridCoverage;
    private RasterLayerRequest originatingCoverageRequest;
    private ImageReaderSpi readerSpi;
    private GridCoverageFactory coverageFactory;
    private Hints hints;
    private MathTransform raster2Model;
    private GeneralEnvelope coverageEnvelope;
    private CoordinateReferenceSystem coverageCRS;
    private String coverageName;
    private MultiLevelROI multiLevelRoi;
    private FootprintBehavior footprintBehavior = FootprintBehavior.None;

    public RasterLayerResponse(RasterLayerRequest request, GridCoverageFactory coverageFactory, ImageReaderSpi readerSpi) {
        this.originatingCoverageRequest = request;
        this.hints = request.getHints();
        this.coverageEnvelope = request.getCoverageEnvelope();
        this.coverageCRS = request.getCoverageCRS();
        this.raster2Model = request.getRaster2Model();
        this.coverageName = request.getCoverageName();
        this.coverageFactory = coverageFactory;
        this.readerSpi = readerSpi;
        this.multiLevelRoi = request.getMultiLevelRoi();
        this.footprintBehavior = request.getFootprintBehavior();
    }

    public GridCoverage getGridCoverage() {
        return this.gridCoverage;
    }

    public RasterLayerRequest getOriginatingCoverageRequest() {
        return this.originatingCoverageRequest;
    }

    public void compute() throws IOException {
        this.originatingCoverageRequest.prepare();
        if (this.originatingCoverageRequest.isEmptyRequest()) {
            this.gridCoverage = null;
        } else {
            ImageReadParam imageReadParam = this.originatingCoverageRequest.getImageReadParam();
            File input = this.originatingCoverageRequest.getInput();
            boolean useMultithreading = this.originatingCoverageRequest.useMultithreading();
            boolean newTransform = this.originatingCoverageRequest.isAdjustGridToWorldSet();
            boolean useJAI = this.originatingCoverageRequest.useJAI();
            this.gridCoverage = this.createCoverage(input, imageReadParam, useJAI, useMultithreading, newTransform);
        }
    }

    private GridCoverage createCoverage(File input, ImageReadParam imageReadParam, boolean useJAI, boolean useMultithreading, boolean adjustGridToWorld) throws IOException {
        ReferencedEnvelope cropBBox;
        PlanarImage raster = this.readRaster(input, useJAI, imageReadParam, useMultithreading);
        boolean useFootprint = this.multiLevelRoi != null && this.footprintBehavior != null && this.footprintBehavior.handleFootprints();
        Geometry inclusionGeometry = useFootprint ? this.multiLevelRoi.getFootprint() : null;
        ReferencedEnvelope granuleBBOX = this.originatingCoverageRequest.getCoverageBBOX();
        ReferencedEnvelope bbox = useFootprint ? new ReferencedEnvelope((Envelope)granuleBBOX.intersection(inclusionGeometry.getEnvelopeInternal()), granuleBBOX.getCoordinateReferenceSystem()) : granuleBBOX;
        ReferencedEnvelope intersection = new ReferencedEnvelope((Envelope)bbox.intersection((Envelope)(cropBBox = new ReferencedEnvelope(this.originatingCoverageRequest.getRequestedBBox()))), cropBBox.getCoordinateReferenceSystem());
        if (intersection.isEmpty() || useFootprint && inclusionGeometry != null && !JTS.toGeometry((ReferencedEnvelope)cropBBox).intersects(inclusionGeometry)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Got empty intersection for granule " + this.toString() + " with request " + this.originatingCoverageRequest.toString() + " Resulting in no data loaded: Empty result");
            }
            return null;
        }
        if (useFootprint) {
            try {
                ROI transformed;
                int width = raster.getWidth();
                int height = raster.getHeight();
                Rectangle imgBounds = new Rectangle(raster.getMinX(), raster.getMinY(), width, height);
                Rectangle sourceArea = imageReadParam.getSourceRegion();
                AffineTransform finalRaster2Model = new AffineTransform((AffineTransform)this.originatingCoverageRequest.getRaster2Model());
                finalRaster2Model.concatenate(CoverageUtilities.CENTER_TO_CORNER);
                double decimationScaleX = 1.0 * (double)sourceArea.width / (double)width;
                double decimationScaleY = 1.0 * (double)sourceArea.height / (double)height;
                AffineTransform decimationScaleTranform = XAffineTransform.getScaleInstance((double)decimationScaleX, (double)decimationScaleY);
                AffineTransform afterDecimationTranslateTranform = XAffineTransform.getTranslateInstance((double)sourceArea.x, (double)sourceArea.y);
                if (!XAffineTransform.isIdentity((AffineTransform)afterDecimationTranslateTranform, (double)1.0E-6)) {
                    finalRaster2Model.concatenate(afterDecimationTranslateTranform);
                }
                if (!XAffineTransform.isIdentity((AffineTransform)decimationScaleTranform, (double)1.0E-6)) {
                    finalRaster2Model.concatenate(decimationScaleTranform);
                }
                if ((transformed = this.multiLevelRoi.getTransformedROI(finalRaster2Model.createInverse(), 0, imgBounds, imageReadParam, this.originatingCoverageRequest.getReadType())) instanceof ROIGeometry && ((ROIGeometry)transformed).getAsGeometry().isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("The transformed geometry became empty, maybe due to inset having wiped out the geometry. Returning null");
                    }
                    return null;
                }
                PlanarImage pi = PlanarImage.wrapRenderedImage((RenderedImage)raster);
                if (!transformed.intersects(pi.getBounds())) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("The transformed geometry doesn't intersect the image bounds. Returning null");
                    }
                    return null;
                }
                pi.setProperty("ROI", (Object)transformed);
                raster = PlanarImage.wrapRenderedImage((RenderedImage)this.footprintBehavior.postProcessMosaic((RenderedImage)raster, transformed, (RenderingHints)this.hints));
            }
            catch (NoninvertibleTransformException e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Unable to create inverse transformation from GridToWorld when managing the ROI");
                }
                return null;
            }
        }
        if (adjustGridToWorld) {
            int ssWidth = raster.getWidth();
            int ssHeight = raster.getHeight();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Coverage read: width = " + ssWidth + " height = " + ssHeight);
            }
            Rectangle sourceRegion = imageReadParam.getSourceRegion();
            double scaleX = (double)sourceRegion.width / (1.0 * (double)ssWidth);
            double scaleY = (double)sourceRegion.height / (1.0 * (double)ssHeight);
            double translateX = sourceRegion.x;
            double translateY = sourceRegion.y;
            return this.createCoverageFromImage(raster, ConcatenatedTransform.create((MathTransform)ProjectiveTransform.create((AffineTransform)new AffineTransform(scaleX, 0.0, 0.0, scaleY, translateX, translateY)), (MathTransform)this.raster2Model));
        }
        return this.createCoverageFromImage(raster);
    }

    protected GridCoverage createCoverageFromImage(PlanarImage image, MathTransform raster2Model) throws IOException {
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        HashSet bandNames = new HashSet();
        for (int i = 0; i < numBands; ++i) {
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)i);
            String bandName = colorInterpretation == null || colorInterpretation == ColorInterpretation.UNDEFINED || bandNames.contains(colorInterpretation.name()) ? "Band" + (i + 1) : colorInterpretation.name();
            bands[i] = new GridSampleDimension((CharSequence)bandName);
        }
        if (raster2Model != null) {
            return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, this.coverageCRS, raster2Model, bands, null, null);
        }
        return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, (org.opengis.geometry.Envelope)new GeneralEnvelope((org.opengis.geometry.Envelope)this.coverageEnvelope), bands, null, null);
    }

    protected GridCoverage createCoverageFromImage(PlanarImage image) throws IOException {
        return this.createCoverageFromImage(image, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlanarImage readRaster(File input, boolean useJAI, ImageReadParam imageReadParam, boolean useMultithreading) throws IOException {
        PlanarImage raster;
        FileImageInputStreamExtImpl fiis = null;
        if (useJAI) {
            fiis = new FileImageInputStreamExtImpl(input);
            ImageReader reader = this.readerSpi.createReaderInstance();
            ParameterBlock pbjImageRead = new ParameterBlock();
            pbjImageRead.add(fiis);
            pbjImageRead.add(0);
            pbjImageRead.add(Boolean.FALSE);
            pbjImageRead.add(Boolean.FALSE);
            pbjImageRead.add(Boolean.FALSE);
            pbjImageRead.add(null);
            pbjImageRead.add(null);
            pbjImageRead.add(imageReadParam);
            pbjImageRead.add(reader);
            String jaiOperation = useMultithreading ? "ImageReadMT" : "ImageRead";
            raster = JAI.create((String)jaiOperation, (ParameterBlock)pbjImageRead, (RenderingHints)this.hints);
        } else {
            ImageReader reader = this.readerSpi.createReaderInstance();
            fiis = new FileImageInputStreamExtImpl(input);
            try {
                reader.setInput(fiis, true, true);
                raster = PlanarImage.wrapRenderedImage((RenderedImage)reader.read(0, imageReadParam));
            }
            finally {
                block17: {
                    block16: {
                        if (fiis != null) {
                            try {
                                fiis.close();
                            }
                            catch (Exception e) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block16;
                                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.dispose();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block17;
                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                }
            }
        }
        return raster;
    }
}

