/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio;

import it.geosolutions.imageio.imageioimpl.imagereadmt.ImageReadDescriptorMT;
import it.geosolutions.imageio.stream.AccessibleStream;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.JAI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProvider;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProviderFactory;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.coverageio.GridCoverageUtilities;
import org.geotools.coverageio.RasterLayerRequest;
import org.geotools.coverageio.RasterLayerResponse;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultResourceInfo;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.PrjFileReader;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.data.WorldFileReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.PixelTranslation;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class BaseGridCoverage2DReader
extends AbstractGridCoverage2DReader
implements GridCoverage2DReader {
    private static final Logger LOGGER;
    private final String worldFileExt;
    private final ImageReaderSpi readerSPI;
    private MultiLevelROIProvider roiProvider;
    protected MultiLevelROI multiLevelRoi;
    private File inputFile = null;
    private String parentPath;
    private ServiceInfo serviceInfo;
    private ResourceInfo resourceInfo;

    protected abstract void setCoverageProperties(ImageReader var1) throws IOException;

    protected BaseGridCoverage2DReader(Object input, Hints hints, String worldFileExtension, ImageReaderSpi formatSpecificSpi) throws DataSourceException {
        super(input, hints);
        ImageReader reader = null;
        try {
            this.readerSPI = formatSpecificSpi;
            this.worldFileExt = worldFileExtension;
            this.checkSource(input);
            reader = this.readerSPI.createReaderInstance();
            reader.setInput(this.inputFile);
            this.setCoverageProperties(reader);
            this.setRoiProvider();
            this.setLayout(reader);
            this.getResolutionInfo(reader);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException((Throwable)e);
        }
        catch (TransformException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException((Throwable)e);
        }
        finally {
            block19: {
                if (reader != null) {
                    block18: {
                        try {
                            reader.reset();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block18;
                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                    try {
                        reader.dispose();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block19;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    private void setRoiProvider() throws IOException {
        Polygon granuleGeometry = JTS.toGeometry((ReferencedEnvelope)new ReferencedEnvelope((Envelope)this.originalEnvelope));
        this.roiProvider = MultiLevelROIProviderFactory.createFootprintProvider((File)this.inputFile, (Geometry)granuleGeometry);
        if (this.roiProvider != null) {
            this.multiLevelRoi = this.roiProvider.getMultiScaleROI(null);
        }
    }

    protected MultiLevelROIProvider getMultiLevelROIProvider(String coverageName) {
        return this.roiProvider;
    }

    double[] getHighestRes() {
        return this.highestRes;
    }

    Hints getHints() {
        return this.hints;
    }

    MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    private void checkSource(Object input) throws UnsupportedEncodingException, IOException, FileNotFoundException {
        File sourceFile;
        if (input instanceof URL) {
            URL sourceURL = (URL)input;
            this.source = sourceURL;
            if (sourceURL.getProtocol().compareToIgnoreCase("file") == 0) {
                this.inputFile = URLs.urlToFile((URL)sourceURL);
                input = this.inputFile;
            } else {
                throw new IllegalArgumentException("Unsupported input type");
            }
        }
        if (input instanceof AccessibleStream) {
            AccessibleStream accessible;
            if (this.source == null) {
                this.source = input;
            }
            if ((accessible = (AccessibleStream)input).getTarget() instanceof File) {
                this.inputFile = (File)accessible.getTarget();
                input = this.inputFile;
            }
        }
        if (input instanceof String) {
            try {
                sourceFile = new File((String)input);
                if (!sourceFile.exists()) {
                    throw new IllegalArgumentException("Unsupported input type, string but not an existing path: " + input);
                }
                input = sourceFile;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, "Failed to test if input string is a valid file", e);
            }
        }
        if (input instanceof File) {
            sourceFile = (File)input;
            if (this.source == null) {
                this.source = sourceFile;
            }
            if (this.inputFile == null) {
                this.inputFile = sourceFile;
            }
            if (!sourceFile.exists() || sourceFile.isDirectory() || !sourceFile.canRead()) {
                throw new DataSourceException("Provided file does not exist or is a directory or is not readable!");
            }
        } else {
            throw new IllegalArgumentException("Unsupported input type");
        }
        this.parentPath = sourceFile.getParent();
        this.coverageName = sourceFile.getName();
        int dotIndex = this.coverageName.lastIndexOf(".");
        this.coverageName = dotIndex == -1 ? this.coverageName : this.coverageName.substring(0, dotIndex);
    }

    private void getResolutionInfo(ImageReader reader) throws IOException, TransformException {
        Rectangle originalDim = new Rectangle(0, 0, reader.getWidth(0), reader.getHeight(0));
        if (this.originalGridRange == null) {
            this.originalGridRange = new GridEnvelope2D(originalDim);
        }
        this.highestRes = CoverageUtilities.getResolution((AffineTransform)((AffineTransform)this.raster2Model));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Highest Resolution = [").append(this.highestRes[0]).append(",").append(this.highestRes[1]).toString());
        }
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        RasterLayerRequest request = new RasterLayerRequest(params, this);
        RasterLayerResponse response = this.requestCoverage(request);
        GridCoverage2D gridCoverage = null;
        if (response != null) {
            gridCoverage = (GridCoverage2D)response.getGridCoverage();
        }
        return gridCoverage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parsePRJFile() {
        String prjPath = null;
        this.crs = null;
        prjPath = this.parentPath + File.separatorChar + this.coverageName + ".prj";
        PrjFileReader projReader = null;
        FileInputStream inStream = null;
        AbstractInterruptibleChannel channel = null;
        try {
            File prj = new File(prjPath);
            if (prj.exists() && prj.canRead()) {
                inStream = new FileInputStream(prj);
                channel = inStream.getChannel();
                projReader = new PrjFileReader((ReadableByteChannel)((Object)channel));
                this.crs = projReader.getCoordinateReferenceSystem();
            }
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        catch (FactoryException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        finally {
            block49: {
                block48: {
                    block47: {
                        if (projReader != null) {
                            try {
                                projReader.close();
                            }
                            catch (IOException e) {
                                if (!LOGGER.isLoggable(Level.WARNING)) break block47;
                                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                            }
                        }
                    }
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable e) {
                            if (!LOGGER.isLoggable(Level.WARNING)) break block48;
                            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                        }
                    }
                }
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block49;
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    protected void parseWorldFile() {
        block9: {
            String worldFilePath = new StringBuffer(this.parentPath).append(GridCoverageUtilities.SEPARATOR).append(this.coverageName).toString();
            File file2Parse = null;
            boolean worldFileExists = false;
            if (this.worldFileExt != null && this.worldFileExt.length() > 0) {
                file2Parse = new File(worldFilePath + this.worldFileExt);
                worldFileExists = file2Parse.exists();
            }
            if (!worldFileExists) {
                file2Parse = new File(worldFilePath + ".wld");
                worldFileExists = file2Parse.exists();
            }
            if (worldFileExists) {
                try {
                    GeneralEnvelope coverageEnvelope;
                    WorldFileReader reader = new WorldFileReader(file2Parse);
                    this.raster2Model = reader.getTransform();
                    MathTransform tempTransform = PixelTranslation.translate((MathTransform)this.raster2Model, (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
                    GeneralEnvelope gridRange = new GeneralEnvelope((Rectangle2D)((GridEnvelope2D)this.originalGridRange));
                    this.originalEnvelope = coverageEnvelope = CRS.transform((MathTransform)tempTransform, (Envelope)gridRange);
                    return;
                }
                catch (TransformException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
                catch (IllegalStateException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block9;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
        this.raster2Model = null;
    }

    public synchronized ServiceInfo getInfo() {
        if (this.serviceInfo != null) {
            return new DefaultServiceInfo(this.serviceInfo);
        }
        DefaultServiceInfo localInfo = new DefaultServiceInfo();
        this.serviceInfo = localInfo;
        localInfo.setDescription(this.source.toString());
        if (this.source instanceof URL) {
            URL url = (URL)this.source;
            localInfo.setTitle(url.getFile());
            try {
                localInfo.setSource(url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else if (this.source instanceof File) {
            File file = (File)this.source;
            String filename = file.getName();
            if (filename == null || filename.length() == 0) {
                localInfo.setTitle(file.getName());
            }
            localInfo.setSource(file.toURI());
        }
        return new DefaultServiceInfo((ServiceInfo)localInfo);
    }

    public synchronized ResourceInfo getInfo(String subname) {
        if (this.resourceInfo != null) {
            return new DefaultResourceInfo(this.resourceInfo);
        }
        DefaultResourceInfo localInfo = new DefaultResourceInfo();
        this.resourceInfo = localInfo;
        localInfo.setName(subname);
        localInfo.setBounds(new ReferencedEnvelope((Envelope)this.getOriginalEnvelope()));
        localInfo.setCRS(this.getCoordinateReferenceSystem());
        localInfo.setTitle(subname);
        return new DefaultResourceInfo(this.resourceInfo);
    }

    private RasterLayerResponse requestCoverage(RasterLayerRequest request) {
        RasterLayerResponse response = new RasterLayerResponse(request, this.coverageFactory, this.readerSPI);
        try {
            response.compute();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
        return response;
    }

    protected File getInputFile() {
        return this.inputFile;
    }

    public String getCoverageName() {
        return this.coverageName;
    }

    public int getGridCoverageCount() {
        return 1;
    }

    protected MultiLevelROI getMultiLevelRoi() {
        return this.multiLevelRoi;
    }

    static {
        block2: {
            LOGGER = Logging.getLogger(BaseGridCoverage2DReader.class);
            try {
                ImageReadDescriptorMT.register((JAI)JAI.getDefaultInstance());
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
    }
}

