/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal.idrisi;

import it.geosolutions.imageio.plugins.idrisi.IDRISIImageReaderSpi;
import java.awt.RenderingHints;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.coverageio.gdal.idrisi.IDRISIFormat;
import org.geotools.util.logging.Logging;

public final class IDRISIFormatFactory
implements GridFormatFactorySpi {
    private static final Logger LOGGER = Logging.getLogger(IDRISIFormatFactory.class);

    public boolean isAvailable() {
        boolean available = true;
        try {
            Class.forName("it.geosolutions.imageio.plugins.arcbinarygrid.ArcBinaryGridImageReaderSpi");
            available = new IDRISIImageReaderSpi().isAvailable();
            if (LOGGER.isLoggable(Level.FINE)) {
                if (available) {
                    LOGGER.fine("IDRISIFormatFactory is available.");
                } else {
                    LOGGER.fine("IDRISIFormatFactory is not available.");
                }
            }
        }
        catch (ClassNotFoundException cnf) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("IDRISIFormatFactory is not available.");
            }
            available = false;
        }
        return available;
    }

    public IDRISIFormat createFormat() {
        return new IDRISIFormat();
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }
}

