/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal.idrisi;

import it.geosolutions.imageio.plugins.arcbinarygrid.ArcBinaryGridImageReaderSpi;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverageio.gdal.BaseGDALGridFormat;
import org.geotools.coverageio.gdal.idrisi.IDRISIReader;
import org.geotools.data.DataSourceException;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.MismatchedDimensionException;

public final class IDRISIFormat
extends BaseGDALGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(IDRISIFormat.class);

    public IDRISIFormat() {
        super((ImageReaderSpi)new ArcBinaryGridImageReaderSpi());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating a new IDRISIFormat.");
        }
        this.setInfo();
    }

    @Override
    protected void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "RST");
        info.put("description", "IDRIS (RST) Coverage Format");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = Collections.unmodifiableMap(info);
        this.writeParameters = null;
        this.readParameters = IDRISIFormat.getDefaultParameterGroup(info);
    }

    public IDRISIReader getReader(Object source, Hints hints) {
        try {
            return new IDRISIReader(source, hints);
        }
        catch (DataSourceException | MismatchedDimensionException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
    }
}

