/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public abstract class BaseGDALGridFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(BaseGDALGridFormat.class);
    private final ImageReaderSpi spi;
    private static final String USE_MT = "USE_MULTITHREADING";
    public static final DefaultParameterDescriptor<Boolean> USE_MULTITHREADING = new DefaultParameterDescriptor("USE_MULTITHREADING", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    protected static final GeneralParameterDescriptor[] PARAM_DESCRIPTOR = new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, USE_JAI_IMAGEREAD, USE_MULTITHREADING, SUGGESTED_TILE_SIZE, FOOTPRINT_BEHAVIOR};

    protected BaseGDALGridFormat(ImageReaderSpi spi) {
        this.spi = spi;
        this.setInfo();
    }

    protected abstract void setInfo();

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin does not support writing at this time.");
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("This plugin does not support writing parameters");
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("This plugin does not support writing at this time.");
    }

    public boolean accepts(Object input, Hints hints) {
        try {
            return this.spi.canDecodeInput(input);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return false;
        }
    }

    protected static ParameterGroup getDefaultParameterGroup(Map<String, String> mInfo) {
        return new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(mInfo, PARAM_DESCRIPTOR));
    }

    public AbstractGridCoverage2DReader getReader(Object source) {
        return this.getReader(source, null);
    }

    protected void setInfo(InfoWrapper infoWrapper) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", infoWrapper.name);
        info.put("description", infoWrapper.description);
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = Collections.unmodifiableMap(info);
        this.writeParameters = null;
        this.readParameters = BaseGDALGridFormat.getDefaultParameterGroup(info);
    }

    protected static class InfoWrapper {
        String description;
        String name;

        public InfoWrapper(String description, String name) {
            this.description = description;
            this.name = name;
        }
    }
}

