/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.image;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataSourceException;
import org.geotools.gce.image.WorldImageReader;
import org.geotools.gce.image.WorldImageWriter;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public final class WorldImageFormat
extends AbstractGridFormat
implements Format {
    private static final Set<String> PNG_WFILE_EXT;
    private static final Set<String> TIFF_WFILE_EXT;
    private static final Set<String> JPG_WFILE_EXT;
    private static final Set<String> GIF_WFILE_EXT;
    private static final Set<String> BMP_WFILE_EXT;
    private static final Logger LOGGER;
    public static final ParameterDescriptor<String> FORMAT;

    public WorldImageFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "WorldImage");
        info.put("description", "A raster file accompanied by a spatial data file");
        info.put("vendor", "Geotools");
        info.put("docURL", "http://www.geotools.org/WorldImageReader+formats");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D}));
        this.writeParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{FORMAT}));
    }

    public WorldImageReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        return new WorldImageWriter(destination);
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        return new WorldImageWriter(destination, hints);
    }

    public boolean accepts(Object input, Hints hints) {
        boolean bl;
        block21: {
            String pathname = "";
            if (input instanceof URL) {
                URL url = (URL)input;
                String protocol = url.getProtocol();
                if (protocol.equalsIgnoreCase("file")) {
                    pathname = URLs.urlToFile((URL)url).getPath();
                } else if (protocol.equalsIgnoreCase("http")) {
                    String query;
                    try {
                        query = URLDecoder.decode(url.getQuery().intern(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                        return false;
                    }
                    return query.toLowerCase().intern().indexOf("getmap") != -1;
                }
            } else if (input instanceof File) {
                File file = (File)input;
                pathname = file.getAbsolutePath();
            } else if (input instanceof String) {
                pathname = (String)input;
            } else {
                return false;
            }
            if (!(pathname.endsWith(".gif") || pathname.endsWith(".jpg") || pathname.endsWith(".jpeg") || pathname.endsWith(".tif") || pathname.endsWith(".tiff") || pathname.endsWith(".png") || pathname.endsWith(".bmp"))) {
                return false;
            }
            ImageInputStream is = ImageIO.createImageInputStream(new File(pathname));
            try {
                Iterator<ImageReader> readers = ImageIO.getImageReaders(is);
                bl = readers.hasNext();
                if (is == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public static Set<String> getWorldExtension(String fileExtension) {
        if (fileExtension == null) {
            throw new NullPointerException("Provided input is null");
        }
        if (fileExtension.equalsIgnoreCase("png")) {
            return PNG_WFILE_EXT;
        }
        if (fileExtension.equals("gif")) {
            return GIF_WFILE_EXT;
        }
        if (fileExtension.equalsIgnoreCase("jpg") || fileExtension.equalsIgnoreCase("jpeg")) {
            return JPG_WFILE_EXT;
        }
        if (fileExtension.equalsIgnoreCase("tif") || fileExtension.equalsIgnoreCase("tiff")) {
            return TIFF_WFILE_EXT;
        }
        if (fileExtension.equalsIgnoreCase("bmp")) {
            return BMP_WFILE_EXT;
        }
        throw new IllegalArgumentException("Unsupported file format");
    }

    public WorldImageReader getReader(Object source, Hints hints) {
        try {
            return new WorldImageReader(source, hints);
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        return null;
    }

    static {
        HashSet<String> tempSet = new HashSet<String>(2);
        tempSet.add(".pgw");
        tempSet.add(".pngw");
        PNG_WFILE_EXT = Collections.unmodifiableSet(tempSet);
        tempSet = new HashSet(3);
        tempSet.add(".jpw");
        tempSet.add(".jgw");
        tempSet.add(".jpgw");
        tempSet.add(".jpegw");
        JPG_WFILE_EXT = Collections.unmodifiableSet(tempSet);
        tempSet = new HashSet(2);
        tempSet.add(".gifw");
        tempSet.add(".gfw");
        GIF_WFILE_EXT = Collections.unmodifiableSet(tempSet);
        tempSet = new HashSet(2);
        tempSet.add(".tfw");
        tempSet.add(".tiffw");
        TIFF_WFILE_EXT = Collections.unmodifiableSet(tempSet);
        tempSet = new HashSet(2);
        tempSet.add(".bmw");
        tempSet.add(".bmpw");
        BMP_WFILE_EXT = Collections.unmodifiableSet(tempSet);
        LOGGER = Logging.getLogger(WorldImageFormat.class);
        FORMAT = DefaultParameterDescriptor.create((String)"Format", (CharSequence)"Indicates the output format for this image", String.class, (Object)"png", (boolean)true);
    }
}

