/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.iau;

import java.awt.RenderingHints;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.OrderedAxisCRSAuthorityFactory;
import org.geotools.referencing.iau.IAUAuthorityFactory;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;

public class IAULongitudeFirstFactory
extends DeferredAuthorityFactory
implements CRSAuthorityFactory {
    public IAULongitudeFirstFactory() {
        this(null);
    }

    public IAULongitudeFirstFactory(Hints userHints) {
        super(userHints, 90 + IAULongitudeFirstFactory.relativePriority());
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
        this.put(userHints, Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        this.put(userHints, Hints.FORCE_STANDARD_AXIS_UNITS);
    }

    private void put(Hints userHints, Hints.Key key) {
        Object value = null;
        if (userHints != null) {
            value = userHints.get((Object)key);
        }
        if (value == null) {
            value = Boolean.FALSE;
        }
        this.hints.put(key, value);
    }

    private static int relativePriority() {
        return -7;
    }

    public Citation getAuthority() {
        return Citations.IAU;
    }

    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        AbstractAuthorityFactory factory;
        Hints backingStoreHints = new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, IAUAuthorityFactory.class);
        backingStoreHints.put((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.FALSE);
        backingStoreHints.put((Object)Hints.FORCE_STANDARD_AXIS_DIRECTIONS, (Object)Boolean.FALSE);
        backingStoreHints.put((Object)Hints.FORCE_STANDARD_AXIS_UNITS, (Object)Boolean.FALSE);
        try {
            factory = (AbstractAuthorityFactory)ReferencingFactoryFinder.getCRSAuthorityFactory((String)"IAU", (Hints)backingStoreHints);
        }
        catch (org.geotools.util.factory.FactoryNotFoundException exception) {
            throw new FactoryNotFoundException((Exception)((Object)exception));
        }
        catch (FactoryRegistryException exception) {
            throw new FactoryException((Exception)((Object)exception));
        }
        return new OrderedAxisCRSAuthorityFactory(factory, new Hints(this.hints), null);
    }
}

