/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.awt.RenderingHints;
import org.geotools.http.CustomHTTPClientFactory;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.http.HTTPConnectionPooling;
import org.geotools.http.HTTPProxy;
import org.geotools.http.LoggingHTTPClient;
import org.geotools.http.SimpleHttpClient;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HTTPClientFinderTest {
    @Before
    public void resetFactoryRegistry() {
        HTTPClientFinder.reset();
    }

    @Test
    public void findingSimpleHttpClientAsDefault() throws Exception {
        HTTPClient client = HTTPClientFinder.createClient();
        Assert.assertNotNull((Object)client);
        Assert.assertTrue((boolean)(client instanceof SimpleHttpClient));
    }

    @Test
    public void findingCustomHttpClientTestByHints() throws Exception {
        HTTPClient client = HTTPClientFinder.createClient((Hints)new Hints((RenderingHints.Key)Hints.HTTP_CLIENT, CustomHTTPClientFactory.CustomHttpClient.class));
        Assert.assertTrue((boolean)(client instanceof CustomHTTPClientFactory.CustomHttpClient));
    }

    @Test
    public void usingSystemPropertiesToSetLogging() throws Exception {
        Hints.putSystemDefault((RenderingHints.Key)Hints.HTTP_LOGGING, (Object)"True");
        try {
            HTTPClient client = HTTPClientFinder.createClient();
            Assert.assertTrue((boolean)(client instanceof LoggingHTTPClient));
        }
        finally {
            Hints.removeSystemDefault((RenderingHints.Key)Hints.HTTP_LOGGING);
        }
    }

    @Test
    public void avoidLoggingInspiteSystemProperty() throws Exception {
        Hints.putSystemDefault((RenderingHints.Key)Hints.HTTP_LOGGING, (Object)"True");
        try {
            HTTPClient client = HTTPClientFinder.createClient((Hints)new Hints((RenderingHints.Key)Hints.HTTP_LOGGING, (Object)"False"));
            Assert.assertTrue((boolean)(client instanceof SimpleHttpClient));
        }
        finally {
            Hints.removeSystemDefault((RenderingHints.Key)Hints.HTTP_LOGGING);
        }
    }

    @Test
    public void usingSystemPropertiesToSetLoggingWithCharset() throws Exception {
        Hints.putSystemDefault((RenderingHints.Key)Hints.HTTP_LOGGING, (Object)"utf-8");
        try {
            try {
                HTTPClientFinder.createClient();
                Assert.fail((String)"Wrong HTTP_LOGGING should end up with exception.");
            }
            catch (RuntimeException ex) {
                Assert.assertEquals((String)"Exception when HTTP_LOGGING set to something else than true/false", (Object)"HTTP_LOGGING value utf-8 is unknown.", (Object)ex.getMessage());
            }
        }
        finally {
            Hints.removeSystemDefault((RenderingHints.Key)Hints.HTTP_LOGGING);
        }
    }

    @Test
    public void askingForNonExistingBehavior() throws Exception {
        try {
            HTTPClientFinder.createClient((Class[])new Class[]{HTTPConnectionPooling.class});
        }
        catch (RuntimeException ex) {
            Assert.assertEquals((String)"Exception message when asking for non existing behavior.", (Object)"Couldn't create HTTP client.\nBehaviors:HTTPConnectionPooling", (Object)ex.getMessage());
        }
    }

    @Test
    public void createClientWithSystemProxyHost() throws Exception {
        boolean nullInitially;
        boolean bl = nullInitially = System.getProperty("http.proxyHost") == null;
        if (nullInitially) {
            System.setProperty("http.proxyHost", "http://proxy.dummy/");
        }
        try {
            HTTPClient client = HTTPClientFinder.createClient((Class[])new Class[]{HTTPProxy.class});
            Assert.assertTrue((boolean)(client instanceof SimpleHttpClient));
        }
        finally {
            if (nullInitially) {
                System.clearProperty("http.proxyHost");
            }
        }
    }
}

