/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.awt.RenderingHints;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.geotools.http.DefaultHTTPClientFactory;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.geotools.http.LoggingHTTPClient;
import org.geotools.http.SimpleHttpClient;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultHTTPClientFactoryTest {
    private URL url;
    private ByteArrayInputStream postBody = new ByteArrayInputStream("GeoTools".getBytes());
    private HTTPResponse mockResponse = (HTTPResponse)Mockito.mock(HTTPResponse.class);
    private HTTPClient mockClient = (HTTPClient)Mockito.mock(HTTPClient.class);

    @Before
    public void setUp() throws MalformedURLException {
        this.url = new URL("http://dummy");
    }

    @Test
    public void testBasicUsage() throws Exception {
        HTTPClient client = new DefaultHTTPClientFactory().createClient(new LinkedList());
        Assert.assertNotNull((Object)client);
        Assert.assertTrue((boolean)(client instanceof SimpleHttpClient));
    }

    @Test
    public void testLoggingUsage() throws Exception {
        DefaultHTTPClientFactory factory = new DefaultHTTPClientFactory();
        HTTPClient client = factory.createClient(new Hints((RenderingHints.Key)Hints.HTTP_LOGGING, (Object)"TRUE"), new LinkedList());
        Assert.assertTrue((boolean)(client instanceof LoggingHTTPClient));
        LoggingHTTPClient loggingClient = (LoggingHTTPClient)client;
        Mockito.when((Object)this.mockClient.get((URL)ArgumentMatchers.any())).thenReturn((Object)this.mockResponse);
        Mockito.when((Object)this.mockClient.get((URL)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)this.mockResponse);
        Mockito.when((Object)this.mockClient.post((URL)ArgumentMatchers.any(), (InputStream)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)this.mockResponse);
        Mockito.when((Object)this.mockClient.post((URL)ArgumentMatchers.any(), (InputStream)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)this.mockResponse);
        loggingClient.delegate = this.mockClient;
        loggingClient.get(this.url);
        loggingClient.get(this.url, Collections.emptyMap());
        loggingClient.post(this.url, (InputStream)this.postBody, "text/plain");
        loggingClient.post(this.url, (InputStream)this.postBody, "text/plain", Collections.emptyMap());
        ((HTTPClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).get((URL)ArgumentMatchers.any());
        ((HTTPClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).get((URL)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        ((HTTPClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).post((URL)ArgumentMatchers.any(), (InputStream)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((HTTPClient)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).post((URL)ArgumentMatchers.any(), (InputStream)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }
}

