/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.geotools.http.HTTPResponse;

public class MockHttpResponse
implements HTTPResponse {
    byte[] response;
    String contentType;
    Map<String, String> headers = new HashMap<String, String>();
    Charset charset = StandardCharsets.UTF_8;

    public MockHttpResponse(InputStream stream, String contentType, String ... headers) {
        this.response = this.toByteArray(stream);
        this.contentType = contentType;
        if (headers != null) {
            if (headers.length % 2 != 0) {
                throw new IllegalArgumentException("The headers must be a alternated sequence of keys and values, should have an even number of entries");
            }
            for (int i = 0; i < headers.length; i += 2) {
                String key = headers[i];
                String value = headers[i++];
                this.headers.put(key, value);
            }
        }
    }

    private byte[] toByteArray(InputStream is) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load the response into a reusable byte array", e);
        }
    }

    public MockHttpResponse(InputStream stream, String contentType, Charset charset, String ... headers) {
        this(stream, contentType, headers);
        this.charset = charset;
    }

    public MockHttpResponse(File responseFile, String contentType, String ... headers) throws FileNotFoundException {
        this((InputStream)new FileInputStream(responseFile), contentType, headers);
    }

    public MockHttpResponse(File responseFile, String contentType, Charset charset, String ... headers) throws FileNotFoundException {
        this(responseFile, contentType, headers);
        this.charset = charset;
    }

    public MockHttpResponse(URL response, String contentType, String ... headers) throws IOException {
        this(response.openStream(), contentType, headers);
    }

    public MockHttpResponse(URL response, String contentType, Charset charset, String ... headers) throws IOException {
        this(response, contentType, headers);
        this.charset = charset;
    }

    public MockHttpResponse(String response, String contentType, String ... headers) {
        this(response.getBytes(), contentType, headers);
    }

    public MockHttpResponse(String response, String contentType, Charset charset, String ... headers) {
        this(response.getBytes(charset), contentType, new String[0]);
        this.charset = charset;
    }

    public MockHttpResponse(byte[] response, String contentType, String ... headers) {
        this((InputStream)new ByteArrayInputStream(response), contentType, headers);
    }

    public void dispose() {
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getResponseHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public InputStream getResponseStream() throws IOException {
        return new ByteArrayInputStream(this.response);
    }

    public String getResponseCharset() {
        return this.charset.name();
    }

    public String toString() {
        return new String(this.response, this.charset);
    }

    @Deprecated
    public void setResponseCharset(String responseCharset) {
        this.charset = Charset.forName(responseCharset);
    }
}

