/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.geotools.http.SimpleHttpClient;
import org.junit.Rule;
import org.junit.Test;

public class SimpleHttpClientTest {
    @Rule
    public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort());

    @Test
    public void testBasicHeader() throws IOException {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/test")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<response>Some content</response>")));
        String longPassword = String.join((CharSequence)"", Collections.nCopies(10, "0123456789"));
        String userName = "user";
        SimpleHttpClient client = new SimpleHttpClient();
        client.setUser(userName);
        client.setPassword(longPassword);
        client.get(new URL("http://localhost:" + this.wireMockRule.port() + "/test"));
        String encodedCredentials = "dXNlcjowMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5";
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test")).withHeader("Authorization", WireMock.equalTo((String)("Basic " + encodedCredentials))));
    }
}

