/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.gtopo30;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataSourceException;
import org.geotools.gce.gtopo30.GTopo30Reader;
import org.geotools.gce.gtopo30.GTopo30Writer;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public final class GTopo30Format
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(GTopo30Format.class);

    public GTopo30Format() {
        this.mInfo = new HashMap();
        this.mInfo.put("name", "Gtopo30");
        this.mInfo.put("description", "Gtopo30 Coverage Format");
        this.mInfo.put("vendor", "Geotools");
        this.mInfo.put("docURL", "http://edcdaac.usgs.gov/gtopo30/gtopo30.asp");
        this.mInfo.put("version", "1.0");
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D}));
        this.writeParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{GEOTOOLS_WRITE_PARAMS}));
    }

    public GTopo30Reader getReader(Object o) {
        return this.getReader(o, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        try {
            return new GTopo30Writer(destination);
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        try {
            return new GTopo30Writer(destination, hints);
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public boolean accepts(Object o, Hints hints) {
        URL urlToUse;
        if (o instanceof File) {
            try {
                urlToUse = ((File)o).toURI().toURL();
            }
            catch (MalformedURLException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                return false;
            }
        } else if (o instanceof URL) {
            urlToUse = (URL)o;
        } else if (o instanceof String) {
            try {
                urlToUse = new File((String)o).toURI().toURL();
            }
            catch (MalformedURLException e) {
                try {
                    urlToUse = new URL((String)o);
                }
                catch (MalformedURLException e1) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                    return false;
                }
            }
        } else {
            return false;
        }
        try {
            GTopo30Reader reader = new GTopo30Reader(urlToUse);
            reader.dispose();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return false;
        }
        return true;
    }

    public GTopo30Reader getReader(Object o, Hints hints) {
        try {
            return new GTopo30Reader(o);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        return null;
    }
}

