/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid.oblong;

import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.oblong.Oblong;
import org.geotools.grid.oblong.OblongBuilder;
import org.geotools.grid.oblong.OblongImpl;
import org.geotools.referencing.CRS;

public class Oblongs {
    public static Oblong create(double minX, double minY, double width, double height, CoordinateReferenceSystem crs) {
        return new OblongImpl(minX, minY, width, height, crs);
    }

    public static SimpleFeatureSource createGrid(ReferencedEnvelope bounds, double width, double height, GridFeatureBuilder gridBuilder) {
        return Oblongs.createGrid(bounds, width, height, -1.0, gridBuilder);
    }

    public static SimpleFeatureSource createGrid(ReferencedEnvelope bounds, double width, double height, double vertexSpacing, GridFeatureBuilder gridFeatureBuilder) {
        if (bounds == null || bounds.isEmpty() || bounds.isNull()) {
            throw new IllegalArgumentException("bounds should not be null or empty");
        }
        if (width <= 0.0) {
            throw new IllegalArgumentException("width must be greater than 0");
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException("height must be greater than 0");
        }
        CoordinateReferenceSystem boundsCRS = bounds.getCoordinateReferenceSystem();
        CoordinateReferenceSystem builderCRS = gridFeatureBuilder.getType().getCoordinateReferenceSystem();
        if (boundsCRS != null && builderCRS != null && !CRS.equalsIgnoreMetadata((Object)boundsCRS, (Object)builderCRS)) {
            throw new IllegalArgumentException("Different CRS set for bounds and the feature builder");
        }
        ListFeatureCollection fc = new ListFeatureCollection(gridFeatureBuilder.getType());
        OblongBuilder gridBuilder = new OblongBuilder(bounds, width, height);
        gridBuilder.buildGrid(gridFeatureBuilder, vertexSpacing, fc);
        return DataUtilities.source((FeatureCollection)fc);
    }
}

