/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid;

import org.geotools.geometry.jts.ReferencedEnvelope;

public class Envelopes {
    private static final double EPS = 1.0E-8;

    public static ReferencedEnvelope expandToInclude(ReferencedEnvelope srcEnv, double resolution) {
        double minX = Envelopes.roundOrdinate(srcEnv.getMinX(), resolution, false);
        double maxX = Envelopes.roundOrdinate(srcEnv.getMaxX(), resolution, true);
        double minY = Envelopes.roundOrdinate(srcEnv.getMinY(), resolution, false);
        double maxY = Envelopes.roundOrdinate(srcEnv.getMaxY(), resolution, true);
        ReferencedEnvelope expanded = new ReferencedEnvelope(srcEnv);
        expanded.expandToInclude(minX, minY);
        expanded.expandToInclude(maxX, maxY);
        return expanded;
    }

    private static double roundOrdinate(double ordinate, double resolution, boolean roundUp) {
        double rounded;
        boolean negative;
        double unsigned = Math.abs(ordinate);
        boolean bl = negative = ordinate < 0.0;
        if (negative) {
            boolean bl2 = roundUp = !roundUp;
        }
        if (roundUp) {
            double x = unsigned / resolution;
            int up = x - (double)((long)x) > 1.0E-8 ? 1 : 0;
            rounded = resolution * (double)((long)up + (long)x);
        } else {
            rounded = resolution * (double)((long)(unsigned / resolution));
        }
        return negative ? -rounded : rounded;
    }
}

