/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.grib;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.util.DiskCache2;

public class GribUtilities {
    private static final Logger LOGGER;
    public static final String GRIB_CACHE_DIR = "GRIB_CACHE_DIR";

    public static boolean isValid(File file) {
        String dir = file.getAbsolutePath();
        if (!file.exists()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The specified path doesn't refer to an existing folder. Please check the path: " + dir);
            }
            return false;
        }
        if (!file.isDirectory()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The specified path doesn't refer to a directory. Please check the path: " + dir);
            }
            return false;
        }
        if (!file.canWrite()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("The specified path refers to a directory which can't be written. Please check the path and the permissions for: " + dir);
            }
            return false;
        }
        return true;
    }

    static {
        String dir;
        File file;
        LOGGER = Logger.getLogger("org.geotools.coverage.io.grib.GribUtilities");
        String cacheDir = System.getProperty(GRIB_CACHE_DIR);
        if (cacheDir != null && GribUtilities.isValid(file = new File(dir = cacheDir))) {
            DiskCache2 cache = new DiskCache2(dir, false, 0, 0);
            cache.setAlwaysUseCache(true);
            GribIndexCache.setDiskCache2((DiskCache2)cache);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Setting the GribIndexCache folder to: " + dir);
            }
        }
    }
}

