/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.GeometryAttribute;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;

@DescribeProcess(title="Graticule Label Placement", description="Transforms a set of graticule lines into label points")
public class GraticuleLabelPointProcess
implements VectorProcess {
    static final Logger log = Logger.getLogger("GraticuleLabelPointProcess");
    public static final double DELTA = 0.0;
    SimpleFeatureType schema;
    SimpleFeatureBuilder builder;

    @DescribeResult(name="labels", description="Positions for labels")
    public SimpleFeatureCollection execute(@DescribeParameter(name="grid") SimpleFeatureCollection features, @DescribeParameter(name="boundingBox", min=0) ReferencedEnvelope bounds, @DescribeParameter(name="offset", min=0, max=1, defaultValue="0") Double offset, @DescribeParameter(name="positions", min=0, max=1) String placement) throws ProcessException, FactoryException, TransformException {
        Optional<PositionEnum> opt;
        PositionEnum position = placement == null ? PositionEnum.BOTH : ((opt = PositionEnum.byName(placement)).isPresent() ? opt.get() : PositionEnum.BOTH);
        if (offset == null) {
            offset = 0.0;
        }
        log.fine("Buiilding labels for " + features.size() + " lines, across " + bounds);
        this.schema = this.buildNewSchema((SimpleFeatureType)features.getSchema());
        this.builder = new SimpleFeatureBuilder(this.schema);
        DefaultFeatureCollection results = new DefaultFeatureCollection();
        PreparedGeometry clipper = null;
        if (bounds != null) {
            if (CRS.isTransformationRequired((CoordinateReferenceSystem)bounds.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)((SimpleFeatureType)features.getSchema()).getCoordinateReferenceSystem())) {
                bounds = bounds.transform(((SimpleFeatureType)features.getSchema()).getCoordinateReferenceSystem(), true);
            }
            clipper = PreparedGeometryFactory.prepare((Geometry)JTS.toGeometry((ReferencedEnvelope)bounds));
        }
        try (SimpleFeatureIterator itr = features.features();){
            while (itr.hasNext()) {
                SimpleFeature f;
                SimpleFeature feature = (SimpleFeature)itr.next();
                if (position.equals((Object)PositionEnum.BOTH)) {
                    log.finest("Doing both ");
                    f = this.setPoint(feature, clipper, PositionEnum.TOPLEFT, offset);
                    if (f != null) {
                        results.add(f);
                    }
                    if ((f = this.setPoint(feature, clipper, PositionEnum.BOTTOMRIGHT, offset)) == null) continue;
                    results.add(f);
                    continue;
                }
                f = this.setPoint(feature, clipper, position, offset);
                if (f == null) continue;
                results.add(f);
            }
        }
        log.finest("created " + results.size() + " points");
        return results;
    }

    private SimpleFeatureType buildNewSchema(SimpleFeatureType schema) {
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        sftb.setName(schema.getName().toString() + "-label");
        for (AttributeDescriptor descriptor : schema.getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) {
                sftb.add(descriptor.getLocalName(), Point.class, ((GeometryDescriptor)descriptor).getCoordinateReferenceSystem());
                continue;
            }
            sftb.add(descriptor);
        }
        sftb.add("top", Boolean.class);
        sftb.add("left", Boolean.class);
        sftb.add("anchorX", Double.class);
        sftb.add("anchorY", Double.class);
        sftb.add("offsetX", Double.class);
        sftb.add("offsetY", Double.class);
        return sftb.buildFeatureType();
    }

    private SimpleFeature setPoint(SimpleFeature feature, PreparedGeometry bounds, PositionEnum position, double offset) {
        LineString line = (LineString)feature.getDefaultGeometry();
        boolean horizontal = (Boolean)feature.getAttribute("horizontal");
        Point p = null;
        if (bounds == null || bounds.contains((Geometry)line)) {
            log.finest("bounds contains line - choosing start or end");
            switch (position) {
                case BOTTOMLEFT: {
                    p = line.getStartPoint();
                    break;
                }
                case TOPLEFT: 
                case LEFT: 
                case TOP: {
                    if (horizontal) {
                        p = line.getStartPoint();
                        break;
                    }
                    p = line.getEndPoint();
                    break;
                }
                case TOPRIGHT: {
                    p = line.getEndPoint();
                    break;
                }
                case BOTTOMRIGHT: 
                case RIGHT: 
                case BOTTOM: {
                    p = horizontal ? line.getEndPoint() : line.getStartPoint();
                }
            }
        } else {
            Geometry points = line.intersection(bounds.getGeometry());
            if (log.isLoggable(Level.FINE)) {
                log.finest("line contained bounds " + points + " " + feature.getAttribute("label"));
                log.finest("bounds:" + bounds);
            }
            if (points.getGeometryType() == "LineString" && !points.isEmpty()) {
                Point[] ps = new Point[]{((LineString)points).getStartPoint(), ((LineString)points).getEndPoint()};
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Got a multipoint intersection " + ps[0] + " " + ps[1]);
                }
                Point left = null;
                Point right = null;
                Point top = null;
                Point bottom = null;
                for (Point point : ps) {
                    if (left == null) {
                        left = point;
                    } else if (point.getX() < left.getX()) {
                        left = point;
                    }
                    if (right == null) {
                        right = point;
                    } else if (point.getX() > right.getX()) {
                        right = point;
                    }
                    if (bottom == null) {
                        bottom = point;
                    } else if (point.getY() < bottom.getY()) {
                        bottom = point;
                    }
                    if (top == null) {
                        top = point;
                        continue;
                    }
                    if (!(point.getY() > top.getY())) continue;
                    top = point;
                }
                switch (position) {
                    default: {
                        break;
                    }
                    case TOPLEFT: 
                    case LEFT: 
                    case TOP: {
                        if (horizontal) {
                            p = left;
                            break;
                        }
                        p = top;
                        break;
                    }
                    case TOPRIGHT: {
                        if (horizontal) {
                            p = right;
                            p.getCoordinate().setX(p.getX() - 0.0);
                            break;
                        }
                        p = top;
                        break;
                    }
                    case BOTTOMLEFT: {
                        if (horizontal) {
                            p = left;
                            break;
                        }
                        p = bottom;
                        p.getCoordinate().setY(p.getY() - 0.0);
                        break;
                    }
                    case BOTTOMRIGHT: 
                    case RIGHT: 
                    case BOTTOM: {
                        if (horizontal) {
                            p = right;
                            p.getCoordinate().setX(p.getX() - 0.1);
                            break;
                        }
                        p = bottom;
                        p.getCoordinate().setY(p.getY() - 0.1);
                    }
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("produced " + p + " " + feature.getAttribute("label"));
                }
            } else {
                log.finest("No intersection");
            }
        }
        if (p != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("buiding point at " + p + " " + feature.getAttribute("label"));
            }
            SimpleFeature result = this.buildFeature(p, feature, position, offset);
            return result;
        }
        return null;
    }

    private SimpleFeature buildFeature(Point p, SimpleFeature feature, PositionEnum position, double offset) {
        log.finest("building Feature at " + p + " pos:" + position);
        Collection atts = feature.getProperties();
        for (Property prop : atts) {
            if (prop instanceof GeometryAttribute) {
                this.builder.set(prop.getName(), (Object)p);
                continue;
            }
            this.builder.set(prop.getName(), prop.getValue());
        }
        boolean top = false;
        boolean left = false;
        switch (position) {
            case TOPLEFT: 
            case TOP: 
            case TOPRIGHT: {
                top = true;
            }
        }
        switch (position) {
            case BOTTOMLEFT: 
            case TOPLEFT: 
            case LEFT: {
                left = true;
            }
        }
        this.builder.set("top", (Object)top);
        this.builder.set("left", (Object)left);
        double anchorX = 0.5;
        double anchorY = 0.5;
        double offsetX = 0.0;
        double offsetY = 0.0;
        String startEndMid = (String)feature.getAttribute("sequence");
        if (Boolean.TRUE.equals(feature.getAttribute("horizontal"))) {
            anchorX = left ? 0.0 : 1.0;
            offsetX = offset * (double)(left ? 1 : -1);
            if ("start".equals(startEndMid)) {
                anchorY = 0.0;
                offsetY = offset;
            } else if ("end".equals(startEndMid)) {
                anchorY = 1.0;
                offsetY = -offset;
            }
        } else {
            anchorY = top ? 1.0 : 0.0;
            offsetY = offset * (double)(top ? -1 : 1);
            if ("start".equals(startEndMid)) {
                anchorX = 0.0;
                offsetX = offset;
            } else if ("end".equals(startEndMid)) {
                anchorX = 1.0;
                offsetX = -offset;
            }
        }
        this.builder.set("anchorX", (Object)anchorX);
        this.builder.set("anchorY", (Object)anchorY);
        this.builder.set("offsetX", (Object)offsetX);
        this.builder.set("offsetY", (Object)offsetY);
        SimpleFeature output = this.builder.buildFeature(null);
        log.finest("Feature builder - left:" + output.getAttribute("left") + " top:" + output.getAttribute("top"));
        return output;
    }

    public static enum PositionEnum {
        TOPLEFT,
        BOTTOMLEFT,
        TOPRIGHT,
        BOTTOMRIGHT,
        BOTH,
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        NONE;


        static Optional<PositionEnum> byName(String givenName) {
            return Arrays.stream(PositionEnum.values()).filter(it -> it.name().equalsIgnoreCase(givenName)).findAny();
        }
    }
}

