/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.graticule;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.geotools.api.data.DataStore;
import org.geotools.api.feature.type.Name;
import org.geotools.data.graticule.GraticuleFeatureSource;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class GraticuleDataStore
extends ContentDataStore
implements DataStore {
    static final Logger log = Logger.getLogger("GraticuleDataStore");
    final ReferencedEnvelope bounds;
    ArrayList<Double> steps;

    public GraticuleDataStore(ReferencedEnvelope env, List<Double> steps) {
        this.steps = new ArrayList<Double>(steps);
        Collections.sort(this.steps);
        this.bounds = env;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry contentEntry) throws IOException {
        return new GraticuleFeatureSource(contentEntry, this.steps, this.bounds);
    }

    protected List<Name> createTypeNames() throws IOException {
        NameImpl name = new NameImpl(this.namespaceURI, this.buildTypeName());
        return Collections.singletonList(name);
    }

    private String buildTypeName() {
        StringBuilder n = new StringBuilder("Graticule_");
        DecimalFormat df = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.US));
        n.append(df.format(this.steps.get(0)));
        if (this.steps.size() > 1) {
            n.append("_").append(df.format(this.steps.get(this.steps.size() - 1)));
        }
        return n.toString();
    }
}

