/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.graticule;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.graticule.GraticuleDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.KVP;

public class GraticuleDataStoreFactory
implements DataStoreFactorySpi {
    static final Logger log = Logger.getLogger("GraticuleDataStoreFactory");
    public static final String DISPLAY_NAME = "Graticule";
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false, null, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static DataAccessFactory.Param STEPS = new DataAccessFactory.Param("steps", List.class, "A list of steps for the grids to be produced for", true, null){

        public Object parse(String text) throws Throwable {
            return Arrays.stream(text.split("\\s*,\\s*")).map(Double::parseDouble).collect(Collectors.toList());
        }
    };
    public static final DataAccessFactory.Param BOUNDS = new DataAccessFactory.Param("bounds", ReferencedEnvelope.class, "The maximum bounding box for the grids in the projection that will be used for the grid", true, null){

        public Object parse(String text) {
            Pattern pat = Pattern.compile("\\[([-+]?[0-9]*\\.?[0-9]+) : ([-+]?[0-9]*\\.?[0-9]+), ([-+]?[0-9]*\\.?[0-9]+) : ([-+]?[0-9]*\\.?[0-9]+)\\] \\{(.*)\\}", 40);
            Matcher m = pat.matcher(text);
            m.find();
            double minX = Double.parseDouble(m.group(1));
            double maxX = Double.parseDouble(m.group(2));
            double minY = Double.parseDouble(m.group(3));
            double maxY = Double.parseDouble(m.group(4));
            try {
                CoordinateReferenceSystem crs = CRS.parseWKT((String)m.group(5));
                return new ReferencedEnvelope(minX, maxX, minY, maxY, crs);
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
        }

        public String text(Object value) {
            ReferencedEnvelope env = (ReferencedEnvelope)value;
            return "[" + env.getMinX() + " : " + env.getMaxX() + ", " + env.getMinY() + " : " + env.getMaxY() + "] {" + env.getCoordinateReferenceSystem().toWKT() + "}";
        }
    };
    public static final String STORE_TYPE = "graticule";
    public static final DataAccessFactory.Param TYPE = new DataAccessFactory.Param("type", String.class, "the data store type (graticule)", true, (Object)"graticule");
    static final List<DataAccessFactory.Param> params = new ArrayList<DataAccessFactory.Param>();

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getDescription() {
        return "Generate a set of graticules, with labels at the bounds of the display";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return params.toArray(new DataAccessFactory.Param[0]);
    }

    public boolean isAvailable() {
        return true;
    }

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        List steps = (List)STEPS.lookUp(params);
        ReferencedEnvelope bounds = (ReferencedEnvelope)BOUNDS.lookUp(params);
        URI namespace = (URI)NAMESPACEP.lookUp(params);
        GraticuleDataStore ds = new GraticuleDataStore(bounds, steps);
        if (namespace != null) {
            ds.setNamespaceURI(namespace.toString());
        }
        return ds;
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        return this.createDataStore(params);
    }

    public boolean canProcess(Map<String, ?> params) {
        if (!DataUtilities.canProcess(params, (DataAccessFactory.Param[])this.getParametersInfo())) {
            return false;
        }
        try {
            return STORE_TYPE.equals(TYPE.lookUp(params));
        }
        catch (IOException e) {
            return false;
        }
    }

    static {
        params.add(TYPE);
        params.add(NAMESPACEP);
        params.add(STEPS);
        params.add(BOUNDS);
    }
}

