/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.gce.grassraster.GrassBinaryImageReader;
import org.geotools.gce.grassraster.GrassCoverageReader;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.core.color.AttributeTable;
import org.geotools.gce.grassraster.core.color.JGrassColorTable;
import org.geotools.gce.grassraster.core.color.JlsTokenizer;
import org.geotools.gce.grassraster.metadata.GrassBinaryImageMetadata;
import org.geotools.gce.grassraster.spi.GrassBinaryImageReaderSpi;
import org.geotools.referencing.CRS;

public class JGrassMapEnvironment {
    public static double defaultMapMin = 0.0;
    public static double defaultMapMax = 5000.0;
    private File PERMANENT_MAPSET = null;
    private File MAPSET = null;
    private File LOCATION = null;
    private File DEFAULT_WIND = null;
    private File PROJ_INFO = null;
    private File PROJ_WKT = null;
    private File PROJ_UNITS = null;
    private File WIND = null;
    private File FCELL = null;
    private File CELL = null;
    private File CATS = null;
    private File HIST = null;
    private File CELLHD = null;
    private File COLR = null;
    private File CELLMISC_FORMAT = null;
    private File CELLMISC_QUANT = null;
    private File CELLMISC_RANGE = null;
    private File CELLMISC_NULL = null;
    private JGrassMapEnvironment RECLASSEDENVIRONMENT = null;
    private String mapName;
    private GrassBinaryImageReader coverageReader;
    private HashMap<String, String> coverageMetadataMap;

    public JGrassMapEnvironment(File cellFile) {
        this.CELL = cellFile;
        this.mapName = this.CELL.getName();
        this.MAPSET = this.CELL.getParentFile().getParentFile();
        this.LOCATION = this.MAPSET.getParentFile();
        String permanentFolderPath = this.LOCATION.getAbsolutePath() + File.separator + "PERMANENT";
        this.PERMANENT_MAPSET = new File(permanentFolderPath);
        this.DEFAULT_WIND = new File(permanentFolderPath + File.separator + "DEFAULT_WIND");
        this.PROJ_INFO = new File(permanentFolderPath + File.separator + "PROJ_INFO");
        this.PROJ_WKT = new File(permanentFolderPath + File.separator + "PROJ_INFO.WKT");
        this.PROJ_UNITS = new File(permanentFolderPath + File.separator + "PROJ_UNITS");
        String mapsetPath = this.MAPSET.getAbsolutePath();
        this.WIND = new File(mapsetPath + File.separator + "WIND");
        this.FCELL = new File(mapsetPath + File.separator + "fcell" + File.separator + this.mapName);
        this.CELLHD = new File(mapsetPath + File.separator + "cellhd" + File.separator + this.mapName);
        this.CATS = new File(mapsetPath + File.separator + "cats" + File.separator + this.mapName);
        this.COLR = new File(mapsetPath + File.separator + "colr" + File.separator + this.mapName);
        this.HIST = new File(mapsetPath + File.separator + "hist" + File.separator + this.mapName);
        String cellMiscPath = mapsetPath + File.separator + "cell_misc" + File.separator + this.mapName + File.separator;
        this.CELLMISC_NULL = new File(cellMiscPath + "null");
        this.CELLMISC_FORMAT = new File(cellMiscPath + "f_format");
        this.CELLMISC_QUANT = new File(cellMiscPath + "f_quant");
        this.CELLMISC_RANGE = new File(cellMiscPath + "f_range");
    }

    public JGrassMapEnvironment(File mapsetFile, String mapName) {
        this(new File(mapsetFile.getAbsolutePath() + File.separator + "cell" + File.separator + mapName));
    }

    public void setReclassed(String reclassedMapset, String reclassedMap) {
        String reclassedCell = this.LOCATION.getAbsolutePath() + File.separator + reclassedMapset + File.separator + "cell" + File.separator + reclassedMap;
        this.CELL = new File(reclassedCell);
        this.mapName = this.CELL.getName();
        this.MAPSET = this.CELL.getParentFile().getParentFile();
        this.LOCATION = this.MAPSET.getParentFile();
        String permanentFolderPath = this.LOCATION.getAbsolutePath() + File.separator + "PERMANENT";
        this.PERMANENT_MAPSET = new File(permanentFolderPath);
        this.DEFAULT_WIND = new File(permanentFolderPath + File.separator + "DEFAULT_WIND");
        this.PROJ_INFO = new File(permanentFolderPath + File.separator + "PROJ_INFO");
        this.PROJ_WKT = new File(permanentFolderPath + File.separator + "PROJ_INFO.WKT");
        this.PROJ_UNITS = new File(permanentFolderPath + File.separator + "PROJ_UNITS");
        String mapsetPath = this.MAPSET.getAbsolutePath();
        this.WIND = new File(mapsetPath + File.separator + "WIND");
        this.FCELL = new File(mapsetPath + File.separator + "fcell" + File.separator + this.mapName);
        this.CELLHD = new File(mapsetPath + File.separator + "cellhd" + File.separator + this.mapName);
        this.CATS = new File(mapsetPath + File.separator + "cats" + File.separator + this.mapName);
        this.COLR = new File(mapsetPath + File.separator + "colr" + File.separator + this.mapName);
        this.HIST = new File(mapsetPath + File.separator + "hist" + File.separator + this.mapName);
        String cellMiscPath = mapsetPath + File.separator + "cell_misc" + File.separator + this.mapName + File.separator;
        this.CELLMISC_NULL = new File(cellMiscPath + "null");
        this.CELLMISC_FORMAT = new File(cellMiscPath + "f_format");
        this.CELLMISC_QUANT = new File(cellMiscPath + "f_quant");
        this.CELLMISC_RANGE = new File(cellMiscPath + "f_range");
        this.RECLASSEDENVIRONMENT = this;
    }

    public String getMapName() {
        return this.mapName;
    }

    public File getPERMANENT_MAPSET() {
        return this.PERMANENT_MAPSET;
    }

    public File getMAPSET() {
        return this.MAPSET;
    }

    public File getLOCATION() {
        return this.LOCATION;
    }

    public File getDEFAULT_WIND() {
        return this.DEFAULT_WIND;
    }

    public File getPROJ_INFO() {
        return this.PROJ_INFO;
    }

    public File getPROJ_WKT() {
        return this.PROJ_WKT;
    }

    public File getPROJ_UNITS() {
        return this.PROJ_UNITS;
    }

    public File getWIND() {
        return this.WIND;
    }

    public File getFCELL() {
        return this.FCELL;
    }

    public File getFcellFolder() {
        return this.FCELL.getParentFile();
    }

    public File getCELL() {
        return this.CELL;
    }

    public File getMapFile() {
        return this.CELL;
    }

    public File getCellFolder() {
        return this.CELL.getParentFile();
    }

    public File getCATS() {
        return this.CATS;
    }

    public File getCatsFolder() {
        return this.CATS.getParentFile();
    }

    public File getHIST() {
        return this.HIST;
    }

    public File getCELLHD() {
        return this.CELLHD;
    }

    public File getCOLR() {
        return this.COLR;
    }

    public File getColrFolder() {
        return this.COLR.getParentFile();
    }

    public File getCELLMISC_FORMAT() {
        return this.CELLMISC_FORMAT;
    }

    public File getCELLMISC_QUANT() {
        return this.CELLMISC_QUANT;
    }

    public File getCELLMISC_RANGE() {
        return this.CELLMISC_RANGE;
    }

    public File getCELLMISC_NULL() {
        return this.CELLMISC_NULL;
    }

    public JGrassMapEnvironment getRECLASSEDENVIRONMENT() {
        return this.RECLASSEDENVIRONMENT;
    }

    public List<String> getColorRules(double[] range) throws IOException {
        if (range == null) {
            range = new double[]{defaultMapMin, defaultMapMax};
        }
        JGrassColorTable colorTable = new JGrassColorTable(this, range);
        return colorTable.getColorRules();
    }

    public List<String> getCategories() throws IOException {
        ArrayList<String> categoriesList = new ArrayList<String>();
        try (BufferedReader rdr = new BufferedReader(new FileReader(this.getCATS()));){
            String line;
            AttributeTable attTable = new AttributeTable();
            rdr.readLine();
            rdr.readLine();
            rdr.readLine();
            rdr.readLine();
            while ((line = rdr.readLine()) != null) {
                JlsTokenizer tk = new JlsTokenizer(line, ":");
                if (tk.countTokens() == 2) {
                    float f = Float.parseFloat(tk.nextToken());
                    String att = tk.nextToken().trim();
                    attTable.addAttribute(f, att);
                    continue;
                }
                if (tk.countTokens() != 3) continue;
                float f0 = Float.parseFloat(tk.nextToken());
                float f1 = Float.parseFloat(tk.nextToken());
                String att = tk.nextToken().trim();
                attTable.addAttribute(f0, f1, att);
            }
            Iterator<AttributeTable.CellAttribute> categories = attTable.getCategories();
            while (categories.hasNext()) {
                AttributeTable.CellAttribute object = categories.next();
                categoriesList.add(object.toString());
            }
        }
        return categoriesList;
    }

    public JGrassRegion getActiveRegion() throws IOException {
        JGrassRegion jGrassRegion = new JGrassRegion(this.getWIND().getAbsolutePath());
        return jGrassRegion;
    }

    public double[] getRangeFromColorTable() throws IOException {
        double[] dataRange = new double[2];
        JGrassColorTable colorTable = new JGrassColorTable(this, null);
        List<String> rules = colorTable.getColorRules();
        if (rules.isEmpty()) {
            return null;
        }
        for (int i = 0; i < rules.size(); ++i) {
            String rule = rules.get(i);
            double[] values = new double[2];
            JGrassColorTable.parseColorRule(rule, values, null);
            if (i == 0) {
                dataRange[0] = values[0];
            }
            if (i != rules.size() - 1) continue;
            dataRange[1] = values[1];
        }
        if (dataRange == null || Double.isNaN(dataRange[0]) || Double.isInfinite(dataRange[0]) || Double.isNaN(dataRange[1]) || Double.isInfinite(dataRange[1])) {
            return null;
        }
        return dataRange;
    }

    public double[] getRangeFromRangeFile() throws IOException {
        double[] dataRange = null;
        File rangeFile = this.getCELLMISC_RANGE();
        if (rangeFile.exists()) {
            dataRange = new double[2];
            try (FileInputStream is = new FileInputStream(rangeFile);){
                byte[] numbers = new byte[16];
                int testread = ((InputStream)is).read(numbers);
                if (testread == 16) {
                    ByteBuffer rangeBuffer = ByteBuffer.wrap(numbers);
                    dataRange[0] = rangeBuffer.getDouble();
                    dataRange[1] = rangeBuffer.getDouble();
                }
            }
        }
        if (dataRange == null || Double.isNaN(dataRange[0]) || Double.isInfinite(dataRange[0]) || Double.isNaN(dataRange[1]) || Double.isInfinite(dataRange[1])) {
            return null;
        }
        return dataRange;
    }

    public double[] getRangeFromMapScan() throws IOException {
        GrassCoverageReader coverageReader = new GrassCoverageReader(this.getCELL());
        coverageReader.setParams(PixelInCell.CELL_CENTER, null, false, false, null);
        coverageReader.read(null);
        double[] dataRange = coverageReader.getRange();
        try (FileOutputStream cell_miscRangeStream = new FileOutputStream(this.getCELLMISC_RANGE());){
            ((OutputStream)cell_miscRangeStream).write(JGrassMapEnvironment.double2bytearray(dataRange[0]));
            ((OutputStream)cell_miscRangeStream).write(JGrassMapEnvironment.double2bytearray(dataRange[1]));
        }
        return dataRange;
    }

    public String getLegendString() throws IOException {
        this.checkReader();
        String legendString = this.coverageMetadataMap.get("colorRulesDescriptor");
        return legendString;
    }

    public String getCategoriesString() throws IOException {
        this.checkReader();
        String categoriesString = this.coverageMetadataMap.get("categoriesDescriptor");
        return categoriesString;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() throws Exception {
        File projWtkFile = this.getPROJ_WKT();
        if (projWtkFile.exists()) {
            StringBuffer wtkString = new StringBuffer();
            try (BufferedReader crsReader = new BufferedReader(new FileReader(projWtkFile));){
                String line;
                while ((line = crsReader.readLine()) != null) {
                    wtkString.append(line.trim());
                }
            }
            CoordinateReferenceSystem readCrs = null;
            try {
                readCrs = CRS.parseWKT((String)wtkString.toString());
            }
            catch (FactoryException e) {
                throw new IOException(e.getLocalizedMessage());
            }
            return readCrs;
        }
        return null;
    }

    public JGrassRegion getFileRegion() throws IOException {
        File cellhdFile = this.getCELLHD();
        JGrassRegion fileRegion = new JGrassRegion(cellhdFile.getAbsolutePath());
        return fileRegion;
    }

    private void checkReader() throws IOException {
        if (this.coverageReader == null) {
            this.coverageReader = new GrassBinaryImageReader(new GrassBinaryImageReaderSpi());
            this.coverageReader.setInput(this.getCELL());
            this.coverageMetadataMap = ((GrassBinaryImageMetadata)this.coverageReader.getImageMetadata(0)).toHashMap();
        }
    }

    private static byte[] double2bytearray(double doubleValue) {
        long l = Double.doubleToLongBits(doubleValue);
        byte[] b = new byte[8];
        int shift = 56;
        int k = 0;
        while (k < 8) {
            b[k] = (byte)(l >>> shift);
            ++k;
            shift -= 8;
        }
        return b;
    }
}

