/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster.core.color;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.util.logging.Logging;

public class JGrassColorTable {
    static final Logger LOGGER = Logging.getLogger(JGrassColorTable.class);
    private static final int[][] rainbow = new int[][]{{255, 255, 0}, {0, 255, 0}, {0, 255, 255}, {0, 0, 255}, {255, 0, 255}, {255, 0, 0}};
    private int alpha = 255;
    private List<String> rules = new ArrayList<String>();

    public JGrassColorTable(JGrassMapEnvironment readerGrassEnv, double[] dataRange) throws IOException {
        File colrFile = readerGrassEnv.getCOLR();
        if (!colrFile.exists()) {
            if (dataRange != null) {
                this.rules = JGrassColorTable.createDefaultColorTable(dataRange, this.alpha);
            }
            return;
        }
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(new FileInputStream(colrFile)));){
            String line = rdr.readLine();
            if (line == null) {
                if (colrFile.delete()) {
                    LOGGER.info("removed empty color file");
                }
                this.rules = JGrassColorTable.createDefaultColorTable(dataRange, this.alpha);
                return;
            }
            if ((line = line.trim()).charAt(0) == '%') {
                String[] stringValues = line.split("\\s+");
                if (stringValues.length == 4) {
                    try {
                        this.alpha = Integer.parseInt(stringValues[3]);
                    }
                    catch (NumberFormatException e) {
                        this.alpha = 255;
                    }
                } else {
                    this.alpha = 255;
                }
                while ((line = rdr.readLine()) != null) {
                    this.rules.add(line + " " + this.alpha);
                }
            } else {
                while ((line = rdr.readLine()) != null) {
                    this.rules.add(line + " " + this.alpha);
                }
            }
        }
    }

    public static List<String> createDefaultColorTable(double[] dataRange, int alpha) {
        ArrayList<String> rules = new ArrayList<String>();
        float rinc = (float)(dataRange[1] - dataRange[0]) / 5.0f;
        for (int i = 0; i < 5; ++i) {
            StringBuffer rule = new StringBuffer();
            rule.append(dataRange[0] + (double)((float)i * rinc) + ":");
            rule.append(rainbow[i][0] + ":" + rainbow[i][1] + ":" + rainbow[i][2] + " ");
            rule.append(dataRange[0] + (double)((float)(i + 1) * rinc) + ":");
            rule.append(rainbow[i + 1][0] + ":" + rainbow[i + 1][1] + ":" + rainbow[i + 1][2] + " " + alpha);
            rules.add(rule.toString());
        }
        return rules;
    }

    public List<String> getColorRules() {
        return this.rules;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public static void parseColorRule(String rule, double[] values, Color[] colors) {
        String[] ruleSplit;
        if (colors == null) {
            colors = new Color[2];
        }
        if ((ruleSplit = rule.split("\\s+")).length >= 2) {
            String part1 = ruleSplit[0];
            String part2 = ruleSplit[1];
            int alpha = 255;
            if (ruleSplit.length == 3) {
                alpha = Integer.parseInt(ruleSplit[2]);
            }
            String[] part1Split = part1.split(":");
            String[] part2Split = part2.split(":");
            if (part1Split.length == 2) {
                values[0] = Double.parseDouble(part1Split[0]);
                colors[0] = new Color(Integer.parseInt(part1Split[1]), Integer.parseInt(part1Split[1]), Integer.parseInt(part1Split[1]), alpha);
            } else if (part1Split.length == 4) {
                values[0] = Double.parseDouble(part1Split[0]);
                colors[0] = new Color(Integer.parseInt(part1Split[1]), Integer.parseInt(part1Split[2]), Integer.parseInt(part1Split[3]), alpha);
            } else {
                values[0] = Double.NaN;
                colors[0] = new Color(0, 0, 0);
            }
            if (part2Split.length == 2) {
                values[1] = Double.parseDouble(part2Split[0]);
                colors[1] = new Color(Integer.parseInt(part2Split[1]), Integer.parseInt(part2Split[1]), Integer.parseInt(part2Split[1]), alpha);
            } else if (part2Split.length == 4) {
                values[1] = Double.parseDouble(part2Split[0]);
                colors[1] = new Color(Integer.parseInt(part2Split[1]), Integer.parseInt(part2Split[2]), Integer.parseInt(part2Split[3]), alpha);
            } else {
                values[1] = Double.NaN;
                colors[1] = new Color(255, 255, 255);
            }
        } else if (ruleSplit.length >= 1) {
            String part = ruleSplit[0];
            int alpha = 255;
            String[] partSplit = part.split(":");
            if (partSplit.length == 2) {
                values[0] = Double.parseDouble(partSplit[0]);
                colors[0] = new Color(Integer.parseInt(partSplit[1]), Integer.parseInt(partSplit[1]), Integer.parseInt(partSplit[1]), alpha);
            } else if (partSplit.length == 4) {
                values[0] = Double.parseDouble(partSplit[0]);
                colors[0] = new Color(Integer.parseInt(partSplit[1]), Integer.parseInt(partSplit[2]), Integer.parseInt(partSplit[3]), alpha);
            } else {
                values[0] = Double.NaN;
                colors[0] = new Color(0, 0, 0);
            }
            values[1] = values[0];
            colors[1] = colors[0];
        } else {
            values[0] = -1000.0;
            colors[0] = new Color(0, 0, 0);
            values[1] = 1000.0;
            colors[1] = new Color(255, 255, 255);
        }
    }
}

