/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster.core;

import java.awt.Rectangle;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ComponentSampleModelJAI;
import javax.media.jai.RasterFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.ProgressListener;
import org.geotools.gce.grassraster.DummyProgressListener;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.core.color.AttributeTable;
import org.geotools.gce.grassraster.core.color.JGrassColorTable;
import org.geotools.gce.grassraster.core.color.JlsTokenizer;
import org.geotools.referencing.CRS;
import org.geotools.util.SimpleInternationalString;

public class GrassBinaryRasterReadHandler
implements Closeable {
    private boolean abortRequired = false;
    private ImageInputStream imageIS = null;
    private ImageInputStream imageNullFileIS = null;
    private Double noData = Double.NaN;
    private JGrassMapEnvironment readerGrassEnv = null;
    private List<Object> reclassTable = null;
    private JGrassRegion nativeRasterRegion = null;
    private int readerMapType = -9999;
    private int numberOfBytesPerValue = -9999;
    private boolean compressed = false;
    private boolean isOldIntegerMap = false;
    private long[] addressesOfRows;
    private int rowCacheRow = -1;
    private int firstDataRow = -1;
    private int rasterMapWidth;
    private int rasterMapHeight;
    private boolean useSubSamplingAsRequestedRowcols = false;
    private boolean castDoubleToFloating = false;
    private SampleModel sampleModel = null;
    private ProgressListener monitor = new DummyProgressListener();
    private JGrassRegion activeReadRegion;

    public GrassBinaryRasterReadHandler(File cellFile) {
        this.readerGrassEnv = new JGrassMapEnvironment(cellFile);
        this.abortRequired = false;
    }

    public WritableRaster readRaster(ImageReadParam param, boolean useSubSamplingAsRequestedRowcols, boolean castDoubleToFloating, ProgressListener monitor) throws IOException, DataFormatException {
        this.useSubSamplingAsRequestedRowcols = useSubSamplingAsRequestedRowcols;
        this.castDoubleToFloating = castDoubleToFloating;
        this.monitor = monitor;
        return this.readRaster(param);
    }

    public WritableRaster readRaster(ImageReadParam param) throws IOException, DataFormatException {
        WritableRaster raster;
        block30: {
            int x;
            ByteBuffer rasterByteBuffer;
            int activeCols;
            int activeRows;
            block31: {
                block29: {
                    if (param != null) {
                        Rectangle srcRegion = param.getSourceRegion();
                        int intRealRowsToRead = srcRegion.height;
                        int intRealColsToRead = srcRegion.width;
                        int sourceXSubsampling = param.getSourceXSubsampling();
                        int sourceYSubsampling = param.getSourceYSubsampling();
                        double xRes = this.nativeRasterRegion.getWEResolution();
                        double yRes = this.nativeRasterRegion.getNSResolution();
                        double newWest = this.nativeRasterRegion.getWest() + srcRegion.getMinX() * xRes;
                        double newEast = this.nativeRasterRegion.getWest() + srcRegion.getMaxX() * xRes;
                        double minY = srcRegion.getMinY();
                        double newNorth = this.nativeRasterRegion.getNorth() - minY * yRes;
                        double newSouth = newNorth - (double)srcRegion.height * yRes;
                        this.activeReadRegion = new JGrassRegion(newWest, newEast, newSouth, newNorth, intRealRowsToRead, intRealColsToRead);
                        int colsAtMaxRes = this.activeReadRegion.getCols();
                        int rowsAtMaxRes = this.activeReadRegion.getRows();
                        if (!this.useSubSamplingAsRequestedRowcols) {
                            this.rasterMapWidth = colsAtMaxRes / sourceXSubsampling;
                            this.rasterMapHeight = rowsAtMaxRes / sourceYSubsampling;
                        } else {
                            this.rasterMapWidth = sourceXSubsampling;
                            this.rasterMapHeight = sourceYSubsampling;
                        }
                        this.activeReadRegion.setCols(this.rasterMapWidth);
                        this.activeReadRegion.setRows(this.rasterMapHeight);
                    } else {
                        this.activeReadRegion = new JGrassRegion(this.nativeRasterRegion);
                        this.rasterMapWidth = this.nativeRasterRegion.getCols();
                        this.rasterMapHeight = this.nativeRasterRegion.getRows();
                    }
                    if (this.numberOfBytesPerValue == 8) {
                        raster = !this.castDoubleToFloating ? RasterFactory.createBandedRaster((int)5, (int)this.rasterMapWidth, (int)this.rasterMapHeight, (int)1, null) : RasterFactory.createBandedRaster((int)4, (int)this.rasterMapWidth, (int)this.rasterMapHeight, (int)1, null);
                    } else if (this.numberOfBytesPerValue == 4 && this.readerMapType < 0) {
                        raster = RasterFactory.createBandedRaster((int)4, (int)this.rasterMapWidth, (int)this.rasterMapHeight, (int)1, null);
                    } else if (this.readerMapType > -1) {
                        raster = RasterFactory.createBandedRaster((int)3, (int)this.rasterMapWidth, (int)this.rasterMapHeight, (int)1, null);
                    } else {
                        throw new IOException("Raster type not supported.");
                    }
                    activeRows = this.activeReadRegion.getRows();
                    activeCols = this.activeReadRegion.getCols();
                    int bufferSize = activeRows * activeCols * this.numberOfBytesPerValue;
                    rasterByteBuffer = ByteBuffer.allocate(bufferSize);
                    byte[] nullRow = null;
                    byte[] rowDataCache = new byte[activeCols * this.numberOfBytesPerValue];
                    this.rowCacheRow = -1;
                    this.firstDataRow = -1;
                    int rowindex = -1;
                    int filerows = this.nativeRasterRegion.getRows();
                    double filenorth = this.nativeRasterRegion.getNorth();
                    double filensres = this.nativeRasterRegion.getNSResolution();
                    double datanorth = this.activeReadRegion.getNorth();
                    double datansres = this.activeReadRegion.getNSResolution();
                    this.monitor.started();
                    this.monitor.setTask((InternationalString)new SimpleInternationalString("Read raster map: " + this.readerGrassEnv.getMapName()));
                    float progress = 0.0f;
                    for (double row = 0.0; row < (double)activeRows; row += 1.0) {
                        double filerow = (filenorth - (datanorth - row * datansres)) / filensres;
                        if ((filerow = Math.floor(filerow)) < 0.0 || filerow >= (double)filerows) {
                            if (this.firstDataRow == -1) {
                                ++rowindex;
                            }
                            if (nullRow == null) {
                                nullRow = this.initNullRow(activeCols);
                            }
                            rasterByteBuffer.put(nullRow);
                        } else {
                            if (this.firstDataRow == -1) {
                                this.firstDataRow = rowindex + 1;
                            }
                            if (filerow == (double)this.rowCacheRow) {
                                rasterByteBuffer.put(rowDataCache);
                            } else {
                                this.readRasterRow((int)filerow, rowDataCache, this.activeReadRegion);
                                this.rowCacheRow = (int)filerow;
                                rasterByteBuffer.put(rowDataCache);
                            }
                        }
                        progress = (float)((double)progress + 100.0 * row / (double)activeRows);
                        this.monitor.progress(progress);
                    }
                    this.monitor.complete();
                    rasterByteBuffer.rewind();
                    this.rowCacheRow = -1;
                    nullRow = null;
                    if (this.numberOfBytesPerValue != 8) break block29;
                    if (!this.castDoubleToFloating) {
                        for (int y = 0; y < activeRows; ++y) {
                            for (x = 0; x < activeCols; ++x) {
                                double value = rasterByteBuffer.getDouble();
                                raster.setSample(x, y, 0, value);
                            }
                        }
                    } else {
                        for (int y = 0; y < activeRows; ++y) {
                            for (x = 0; x < activeCols; ++x) {
                                float value = (float)rasterByteBuffer.getDouble();
                                raster.setSample(x, y, 0, value);
                            }
                        }
                    }
                    break block30;
                }
                if (this.numberOfBytesPerValue != 4 || this.readerMapType >= 0) break block31;
                for (int y = 0; y < activeRows; ++y) {
                    for (x = 0; x < activeCols; ++x) {
                        float value = rasterByteBuffer.getFloat();
                        raster.setSample(x, y, 0, value);
                    }
                }
                break block30;
            }
            if (this.readerMapType <= -1) break block30;
            for (int y = 0; y < activeRows; ++y) {
                for (x = 0; x < activeCols; ++x) {
                    int value = rasterByteBuffer.getInt();
                    if (value == Integer.MAX_VALUE) {
                        value = this.noData.intValue();
                    }
                    raster.setSample(x, y, 0, value);
                }
            }
        }
        return raster;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseHeaderAndAccessoryFiles() throws IOException {
        try {
            LinkedHashMap<String, String> readerFileHeaderMap = new LinkedHashMap<String, String>();
            String reclassedFile = null;
            String reclassedMapset = null;
            this.reclassTable = null;
            File cellhd = this.readerGrassEnv.getCELLHD();
            BufferedReader cellhead = new BufferedReader(new FileReader(cellhd));
            cellhead.mark(128);
            String line = cellhead.readLine();
            if (line == null) {
                throw new IOException("The cellhead file seems to be corrupted: " + cellhd.getAbsolutePath());
            }
            if (line.trim().equalsIgnoreCase("reclass")) {
                for (int i = 0; i < 2; ++i) {
                    line = cellhead.readLine();
                    if (line == null) {
                        throw new IOException("The cellhead file seems to be corrupted: " + cellhd.getAbsolutePath());
                    }
                    String[] lineSplit = line.split(":");
                    if (lineSplit.length != 2) continue;
                    if (lineSplit[0].trim().equalsIgnoreCase("name")) {
                        reclassedFile = lineSplit[1].trim();
                        continue;
                    }
                    if (!lineSplit[0].trim().equalsIgnoreCase("mapset")) continue;
                    reclassedMapset = lineSplit[1].trim();
                }
                this.reclassTable = new ArrayList<Object>();
                line = cellhead.readLine();
                if (line == null) {
                    throw new IOException("The cellhead file seems to be corrupted: " + cellhd.getAbsolutePath());
                }
                if (line.charAt(0) == '#') {
                    int reclassFirstCategory = Integer.parseInt(line.trim().substring(1));
                    for (int i = 0; i < reclassFirstCategory; ++i) {
                        this.reclassTable.add("");
                    }
                } else {
                    this.reclassTable.add("");
                }
                while ((line = cellhead.readLine()) != null) {
                    this.reclassTable.add(Integer.valueOf(line));
                }
                this.readerGrassEnv.setReclassed(reclassedMapset, reclassedFile);
                if (!cellhd.exists()) {
                    throw new IOException("The reclassed cellhead file doesn't seems to exist: " + cellhd.getAbsolutePath());
                }
                cellhead = new BufferedReader(new FileReader(cellhd));
            } else {
                cellhead.reset();
            }
            while ((line = cellhead.readLine()) != null) {
                String key;
                String[] lineSplit = line.split(":");
                if (lineSplit.length == 2) {
                    key = lineSplit[0].trim();
                    String value = lineSplit[1].trim();
                    if (key.indexOf("resol") != -1) {
                        readerFileHeaderMap.put(key.replaceAll("resol", "res"), value);
                        continue;
                    }
                    readerFileHeaderMap.put(key, value);
                    continue;
                }
                key = lineSplit[0].trim();
                String degrees = lineSplit[1];
                double value = Double.parseDouble(degrees);
                String minutes = lineSplit[2];
                if (minutes.lastIndexOf(78) != -1 || minutes.lastIndexOf(83) != -1 || minutes.lastIndexOf(69) != -1 || minutes.lastIndexOf(87) != -1) {
                    if (minutes.lastIndexOf(83) != -1 || minutes.lastIndexOf(87) != -1) {
                        value *= -1.0;
                    }
                    minutes = minutes.substring(0, minutes.length() - 1);
                }
                value += Double.parseDouble(minutes) / 60.0;
                if (lineSplit.length == 4) {
                    String seconds = lineSplit[3];
                    if (seconds.lastIndexOf(78) != -1 || seconds.lastIndexOf(83) != -1 || seconds.lastIndexOf(69) != -1 || seconds.lastIndexOf(87) != -1) {
                        if (seconds.lastIndexOf(83) != -1 || seconds.lastIndexOf(87) != -1) {
                            value *= -1.0;
                        }
                        seconds = seconds.substring(0, seconds.length() - 1);
                    }
                    value += Double.parseDouble(seconds) / 60.0 / 60.0;
                }
                if (key.indexOf("resol") != -1) {
                    readerFileHeaderMap.put(key.replaceAll("resol", "res"), String.valueOf(value));
                    continue;
                }
                readerFileHeaderMap.put(key, String.valueOf(value));
            }
            if (readerFileHeaderMap.containsKey("n-s res")) {
                this.nativeRasterRegion = new JGrassRegion(Double.parseDouble((String)readerFileHeaderMap.get("west")), Double.parseDouble((String)readerFileHeaderMap.get("east")), Double.parseDouble((String)readerFileHeaderMap.get("south")), Double.parseDouble((String)readerFileHeaderMap.get("north")), Double.parseDouble((String)readerFileHeaderMap.get("e-w res")), Double.parseDouble((String)readerFileHeaderMap.get("n-s res")));
            } else {
                if (!readerFileHeaderMap.containsKey("cols")) throw new IOException("The map window file seems to be corrupted. Unable to read file region: " + cellhd.getAbsolutePath());
                this.nativeRasterRegion = new JGrassRegion(Double.parseDouble((String)readerFileHeaderMap.get("west")), Double.parseDouble((String)readerFileHeaderMap.get("east")), Double.parseDouble((String)readerFileHeaderMap.get("south")), Double.parseDouble((String)readerFileHeaderMap.get("north")), Integer.parseInt((String)readerFileHeaderMap.get("rows")), Integer.parseInt((String)readerFileHeaderMap.get("cols")));
            }
            if (((String)readerFileHeaderMap.get("format")).equals("")) throw new IOException("The cellhead file seems to be corrupted: " + cellhd.getAbsolutePath());
            this.readerMapType = Integer.parseInt((String)readerFileHeaderMap.get("format"));
            if (this.readerMapType > -1) {
                ++this.readerMapType;
                this.numberOfBytesPerValue = 4;
                this.imageIS = ImageIO.createImageInputStream(this.readerGrassEnv.getCELL());
                this.imageNullFileIS = null;
                if (this.readerGrassEnv.getCELLMISC_NULL().exists()) {
                    this.imageNullFileIS = ImageIO.createImageInputStream(this.readerGrassEnv.getCELLMISC_NULL());
                    this.isOldIntegerMap = this.imageNullFileIS != null;
                }
            } else if (this.readerMapType < 0) {
                if (!this.readerGrassEnv.getCELLMISC_FORMAT().exists()) throw new IOException("Missing required format file: " + this.readerGrassEnv.getCELLMISC_FORMAT().getAbsolutePath());
                BufferedReader cellmiscformat = new BufferedReader(new FileReader(this.readerGrassEnv.getCELLMISC_FORMAT()));
                while ((line = cellmiscformat.readLine()) != null) {
                    StringTokenizer tokk = new StringTokenizer(line, ":");
                    if (tokk.countTokens() != 2) continue;
                    String key = tokk.nextToken().trim();
                    String value = tokk.nextToken().trim();
                    readerFileHeaderMap.put(key, value);
                }
                if (((String)readerFileHeaderMap.get("type")).equals("")) throw new IOException("Wrong number type in format file: " + this.readerGrassEnv.getCELLMISC_FORMAT().getAbsolutePath());
                if (((String)readerFileHeaderMap.get("type")).equalsIgnoreCase("double")) {
                    this.readerMapType = -2;
                    this.numberOfBytesPerValue = 8;
                } else {
                    if (!((String)readerFileHeaderMap.get("type")).equalsIgnoreCase("float")) throw new IOException("Wrong number type in format file: " + this.readerGrassEnv.getCELLMISC_FORMAT().getAbsolutePath());
                    this.readerMapType = -1;
                    this.numberOfBytesPerValue = 4;
                }
                cellmiscformat.close();
                this.isOldIntegerMap = false;
                this.imageIS = ImageIO.createImageInputStream(this.readerGrassEnv.getFCELL());
                this.imageNullFileIS = null;
                if (this.readerGrassEnv.getCELLMISC_NULL().exists()) {
                    this.imageNullFileIS = ImageIO.createImageInputStream(this.readerGrassEnv.getCELLMISC_NULL());
                }
            }
            if (((String)readerFileHeaderMap.get("compressed")).equals("")) {
                throw new IOException("The cellhead file seems to be corrupted: " + cellhd.getAbsolutePath());
            }
            int cmpr = Integer.parseInt((String)readerFileHeaderMap.get("compressed"));
            this.compressed = cmpr == 1;
            cellhead.close();
            this.parseHeader();
            return;
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    private void parseHeader() throws IOException {
        int first = this.imageIS.read();
        int capacity = 1 + first * this.nativeRasterRegion.getRows() + first;
        ByteBuffer fileHeader = ByteBuffer.allocate(capacity);
        this.imageIS.seek(0L);
        byte[] array = fileHeader.array();
        this.imageIS.read(array);
        byte firstbyte = fileHeader.get();
        this.addressesOfRows = new long[this.nativeRasterRegion.getRows() + 1];
        if (firstbyte == 4) {
            for (int i = 0; i <= this.nativeRasterRegion.getRows(); ++i) {
                this.addressesOfRows[i] = fileHeader.getInt();
            }
        } else if (firstbyte == 8) {
            for (int i = 0; i <= this.nativeRasterRegion.getRows(); ++i) {
                this.addressesOfRows[i] = fileHeader.getLong();
            }
        } else {
            throw new IOException("The first byte of the GRASS file header is not 4 and not 8. Unknown case for file: " + this.readerGrassEnv.getCELL().getAbsolutePath());
        }
    }

    private boolean readRasterRow(int currentfilerow, byte[] rowDataCache, JGrassRegion activeReadRegion) throws IOException, DataFormatException {
        ByteBuffer rowBuffer = ByteBuffer.wrap(rowDataCache);
        double activeewres = activeReadRegion.getWEResolution();
        double activewest = activeReadRegion.getWest();
        double filewest = this.nativeRasterRegion.getWest();
        double fileewres = this.nativeRasterRegion.getWEResolution();
        ByteBuffer rowCache = ByteBuffer.allocate(this.nativeRasterRegion.getCols() * (this.readerMapType == -2 ? 8 : 4));
        this.getMapRow(currentfilerow, rowCache);
        for (double col = 0.0; col < (double)activeReadRegion.getCols(); col += 1.0) {
            double x = (activewest + col * activeewres - filewest) / fileewres;
            if ((x = (double)Math.round(x)) < 0.0 || x >= (double)this.nativeRasterRegion.getCols()) {
                if (this.readerMapType > 0) {
                    rowBuffer.putInt(Integer.MAX_VALUE);
                    continue;
                }
                if (this.readerMapType == -1) {
                    rowBuffer.putFloat(Float.NaN);
                    continue;
                }
                if (this.readerMapType != -2) continue;
                rowBuffer.putDouble(Double.NaN);
                continue;
            }
            if (this.readNullValueAtRowCol(currentfilerow, (int)x)) {
                if (this.readerMapType > 0) {
                    rowBuffer.putInt(Integer.MAX_VALUE);
                    continue;
                }
                if (this.readerMapType == -1) {
                    rowBuffer.putFloat(Float.NaN);
                    continue;
                }
                if (this.readerMapType != -2) continue;
                rowBuffer.putDouble(Double.NaN);
                continue;
            }
            rowCache.position((int)x * this.numberOfBytesPerValue);
            if (this.readerMapType > 0) {
                int cell = rowCache.getInt();
                if (cell == 0 && this.isOldIntegerMap) {
                    rowBuffer.putInt(Integer.MAX_VALUE);
                    continue;
                }
                if (this.reclassTable != null) {
                    cell = (Integer)this.reclassTable.get(cell);
                }
                rowBuffer.putInt(cell);
                continue;
            }
            if (this.readerMapType == -1) {
                float cell = rowCache.getFloat();
                if (this.reclassTable != null) {
                    cell = ((Integer)this.reclassTable.get((int)cell)).floatValue();
                }
                rowBuffer.putFloat(cell);
                continue;
            }
            if (this.readerMapType != -2) continue;
            double cell = rowCache.getDouble();
            if (this.reclassTable != null) {
                cell = ((Integer)this.reclassTable.get((int)cell)).doubleValue();
            }
            rowBuffer.putDouble(cell);
        }
        return true;
    }

    private byte[] initNullRow(int activeCols) {
        byte[] nrow;
        block4: {
            int len;
            block5: {
                block3: {
                    len = activeCols * this.numberOfBytesPerValue;
                    nrow = new byte[len];
                    if (this.readerMapType <= 0) break block3;
                    ByteBuffer src = ByteBuffer.allocate(4);
                    src.putInt(Integer.MAX_VALUE);
                    byte[] arr = src.array();
                    for (int i = 0; i < len; i += 4) {
                        System.arraycopy(arr, 0, nrow, i, 4);
                    }
                    break block4;
                }
                if (this.readerMapType != -1) break block5;
                ByteBuffer src = ByteBuffer.allocate(4);
                src.putFloat(Float.NaN);
                byte[] arr = src.array();
                for (int i = 0; i < len; i += 4) {
                    System.arraycopy(arr, 0, nrow, i, 4);
                }
                break block4;
            }
            if (this.readerMapType != -2) break block4;
            ByteBuffer src = ByteBuffer.allocate(8);
            src.putDouble(Double.NaN);
            byte[] arr = src.array();
            for (int i = 0; i < len; i += 8) {
                System.arraycopy(arr, 0, nrow, i, 8);
            }
        }
        return nrow;
    }

    private void getMapRow(int currentrow, ByteBuffer rowdata) throws IOException, DataFormatException {
        if (this.compressed) {
            if (this.readerMapType == -2) {
                this.readCompressedFPRowByNumber(rowdata, currentrow);
            } else if (this.readerMapType == -1) {
                this.readCompressedFPRowByNumber(rowdata, currentrow);
            } else if (this.readerMapType > 0) {
                this.readCompressedIntegerRowByNumber(rowdata, currentrow);
            }
        } else if (this.readerMapType < 0) {
            this.readUncompressedFPRowByNumber(rowdata, currentrow);
        } else if (this.readerMapType > 0) {
            this.readUncompressedIntegerRowByNumber(rowdata, currentrow);
        }
    }

    private void readCompressedFPRowByNumber(ByteBuffer rowdata, int currentrow) throws DataFormatException, IOException {
        int offset = (int)(this.addressesOfRows[currentrow + 1] - this.addressesOfRows[currentrow]);
        byte[] tmp = new byte[offset - 1];
        this.imageIS.seek(this.addressesOfRows[currentrow]);
        int firstbyte = this.imageIS.read() & 0xFF;
        if (firstbyte == 49) {
            this.imageIS.read(tmp, 0, offset - 1);
            Inflater decompresser = new Inflater();
            decompresser.setInput(tmp, 0, tmp.length);
            decompresser.inflate(rowdata.array());
            decompresser.end();
        } else if (firstbyte == 48) {
            this.imageIS.read(rowdata.array(), 0, offset - 1);
        }
    }

    private void readUncompressedFPRowByNumber(ByteBuffer rowdata, int currentrow) throws IOException, DataFormatException {
        int datanumber = this.nativeRasterRegion.getCols() * this.numberOfBytesPerValue;
        this.imageIS.seek((long)currentrow * (long)datanumber);
        this.imageIS.read(rowdata.array());
    }

    private void readCompressedIntegerRowByNumber(ByteBuffer rowdata, int currentrow) throws IOException, DataFormatException {
        int offset = (int)(this.addressesOfRows[currentrow + 1] - this.addressesOfRows[currentrow]);
        this.imageIS.seek(this.addressesOfRows[currentrow]);
        int bytespervalue = this.imageIS.read() & 0xFF;
        ByteBuffer cell = ByteBuffer.allocate(bytespervalue);
        int cellValue = 0;
        byte[] tmp = new byte[offset - 1];
        this.imageIS.read(tmp);
        ByteBuffer tmpBuffer = ByteBuffer.wrap(tmp);
        tmpBuffer.order(ByteOrder.nativeOrder());
        if (offset - 1 == bytespervalue * this.nativeRasterRegion.getCols()) {
            for (int i = 0; i < offset - 1; i += bytespervalue) {
                tmpBuffer.get(cell.array());
                if (bytespervalue == 1) {
                    cellValue = cell.get(0) & 0xFF;
                } else if (bytespervalue == 2) {
                    cellValue = cell.getShort(0);
                } else if (bytespervalue == 4) {
                    cellValue = cell.getInt(0);
                }
                rowdata.putInt(cellValue);
            }
        } else {
            int couples = (offset - 1) / (1 + bytespervalue);
            for (int i = 0; i < couples; ++i) {
                int count = tmpBuffer.get() & 0xFF;
                tmpBuffer.get(cell.array());
                if (bytespervalue == 1) {
                    cellValue = cell.get(0) & 0xFF;
                } else if (bytespervalue == 2) {
                    cellValue = cell.getShort(0);
                } else if (bytespervalue == 4) {
                    cellValue = cell.getInt(0);
                }
                for (int j = 0; j < count; ++j) {
                    rowdata.putInt(cellValue);
                }
            }
        }
    }

    private void readUncompressedIntegerRowByNumber(ByteBuffer rowdata, int currentrow) throws IOException, DataFormatException {
        int cellValue = 0;
        ByteBuffer cell = ByteBuffer.allocate(this.readerMapType);
        int filerowsize = this.nativeRasterRegion.getCols() * this.readerMapType;
        this.imageIS.seek((long)currentrow * (long)filerowsize);
        ByteBuffer tmpBuffer = ByteBuffer.allocate(filerowsize);
        this.imageIS.read(tmpBuffer.array());
        while (tmpBuffer.hasRemaining()) {
            tmpBuffer.get(cell.array());
            if (this.readerMapType == 1) {
                cellValue = cell.get(0) & 0xFF;
            } else if (this.readerMapType == 2) {
                cellValue = cell.getShort(0);
            } else if (this.readerMapType == 4) {
                cellValue = cell.getInt(0);
            }
            rowdata.putInt(cellValue);
        }
    }

    private boolean readNullValueAtRowCol(int currentfilerow, int currentfilecol) throws IOException {
        if (this.imageNullFileIS != null) {
            long byteperrow = (long)Math.ceil((double)this.nativeRasterRegion.getCols() / 8.0);
            long currentByte = (long)Math.ceil((double)(currentfilecol + 1) / 8.0);
            long byteToRead = byteperrow * (long)currentfilerow + currentByte;
            this.imageNullFileIS.seek(byteToRead - 1L);
            int bitposition = currentfilecol % 8;
            byte[] thetmp = new byte[]{this.imageNullFileIS.readByte()};
            BitSet tmp = this.fromByteArray(thetmp);
            boolean theBit = tmp.get(7 - bitposition);
            return theBit;
        }
        return false;
    }

    public JGrassRegion getNativeRasterRegion() {
        return this.nativeRasterRegion;
    }

    public List<String> getColorRules(double[] range) throws IOException {
        JGrassColorTable colorTable = new JGrassColorTable(this.readerGrassEnv, range);
        return colorTable.getColorRules();
    }

    public List<String> getCategories() throws IOException {
        try (BufferedReader rdr = new BufferedReader(new FileReader(this.readerGrassEnv.getCATS()));){
            String line;
            AttributeTable attTable = new AttributeTable();
            rdr.readLine();
            rdr.readLine();
            rdr.readLine();
            rdr.readLine();
            while ((line = rdr.readLine()) != null) {
                if (line.indexOf("0:no data") != -1) continue;
                JlsTokenizer tk = new JlsTokenizer(line, ":");
                if (tk.countTokens() == 2) {
                    float f = Float.parseFloat(tk.nextToken());
                    String att = tk.nextToken().trim();
                    attTable.addAttribute(f, att);
                    continue;
                }
                if (tk.countTokens() != 3) continue;
                float f0 = Float.parseFloat(tk.nextToken());
                float f1 = Float.parseFloat(tk.nextToken());
                String att = tk.nextToken().trim();
                attTable.addAttribute(f0, f1, att);
            }
            ArrayList<String> attrs = new ArrayList<String>();
            Iterator<AttributeTable.CellAttribute> categories = attTable.getCategories();
            while (categories.hasNext()) {
                AttributeTable.CellAttribute object = categories.next();
                attrs.add(object.toString());
            }
            ArrayList<String> arrayList = attrs;
            return arrayList;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.imageIS != null) {
            this.imageIS.close();
            this.imageNullFileIS.close();
        }
    }

    private BitSet fromByteArray(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public void abort() {
        this.abortRequired = true;
    }

    public boolean isAborting() {
        return this.abortRequired;
    }

    public void setNoData(double noData) {
        this.noData = noData;
    }

    public double getNoData() {
        return this.noData;
    }

    public CoordinateReferenceSystem getCrs() throws IOException {
        String locationPath = this.readerGrassEnv.getLOCATION().getAbsolutePath();
        CoordinateReferenceSystem readCrs = null;
        String projWtkFilePath = locationPath + File.separator + "PERMANENT" + File.separator + "PROJ_INFO.WKT";
        File projWtkFile = new File(projWtkFilePath);
        if (projWtkFile.exists()) {
            StringBuffer wtkString = new StringBuffer();
            try (BufferedReader crsReader = new BufferedReader(new FileReader(projWtkFile));){
                String line = null;
                while ((line = crsReader.readLine()) != null) {
                    wtkString.append(line.trim());
                }
            }
            try {
                readCrs = CRS.parseWKT((String)wtkString.toString());
            }
            catch (FactoryException e) {
                throw new IOException(e.getLocalizedMessage());
            }
            return readCrs;
        }
        return null;
    }

    public SampleModel getSampleModel() {
        int[] bands = new int[]{0};
        int[] bandOffsets = new int[]{0};
        this.rasterMapWidth = this.activeReadRegion.getCols();
        this.rasterMapHeight = this.activeReadRegion.getRows();
        if (this.sampleModel == null) {
            if (this.numberOfBytesPerValue == 8) {
                this.sampleModel = !this.castDoubleToFloating ? new ComponentSampleModelJAI(5, this.rasterMapWidth, this.rasterMapHeight, 1, this.rasterMapWidth, bands, bandOffsets) : new ComponentSampleModelJAI(4, this.rasterMapWidth, this.rasterMapHeight, 1, this.rasterMapWidth, bands, bandOffsets);
            } else if (this.numberOfBytesPerValue == 4 && this.readerMapType < 0) {
                this.sampleModel = new ComponentSampleModelJAI(4, this.rasterMapWidth, this.rasterMapHeight, 1, this.rasterMapWidth, bands, bandOffsets);
            } else if (this.readerMapType > -1) {
                this.sampleModel = new ComponentSampleModelJAI(3, this.rasterMapWidth, this.rasterMapHeight, 1, this.rasterMapWidth, bands, bandOffsets);
            }
        }
        return this.sampleModel;
    }

    public int getRasterMapWidth() {
        return this.rasterMapWidth;
    }

    public int getRasterMapHeight() {
        return this.rasterMapHeight;
    }

    public double[] getRange() {
        return null;
    }
}

