/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.PlanarImage;
import org.geotools.api.util.ProgressListener;
import org.geotools.gce.grassraster.DummyProgressListener;
import org.geotools.gce.grassraster.core.GrassBinaryRasterReadHandler;
import org.geotools.gce.grassraster.metadata.GrassBinaryImageMetadata;
import org.geotools.gce.grassraster.spi.GrassBinaryImageReaderSpi;

public class GrassBinaryImageReader
extends ImageReader {
    private GrassBinaryImageMetadata metadata = null;
    private GrassBinaryRasterReadHandler rasterHandler = null;
    private boolean hasListeners;
    public ColorModel ccmdl = null;
    private SampleModel csm = null;
    private ImageTypeSpecifier imageType;
    private HashMap<Integer, BufferedImage> imagesMap = new HashMap();
    private boolean useSubSamplingAsRequestedRowcols = false;
    private boolean castDoubleToFloating = false;
    private ProgressListener monitor = new DummyProgressListener();

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        if (input != null) {
            boolean found = false;
            if (this.originatingProvider != null) {
                Class<?>[] classes;
                for (Class<?> aClass : classes = this.originatingProvider.getInputTypes()) {
                    if (!aClass.isInstance(input)) continue;
                    found = true;
                    break;
                }
            } else if (input instanceof ImageInputStream) {
                found = true;
            }
            if (!found) {
                throw new IllegalArgumentException("Incorrect input type!");
            }
            this.seekForwardOnly = seekForwardOnly;
            this.ignoreMetadata = ignoreMetadata;
            this.minIndex = 0;
        }
        if (input instanceof File) {
            this.input = input;
        }
    }

    public void setUseSubSamplingAsRequestedRowcols(boolean useSubSamplingAsRequestedRowcols) {
        this.useSubSamplingAsRequestedRowcols = useSubSamplingAsRequestedRowcols;
    }

    public void setCastDoubleToFloating(boolean castDoubleToFloating) {
        this.castDoubleToFloating = castDoubleToFloating;
    }

    public GrassBinaryImageReader(GrassBinaryImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    private void ensureOpen() throws IOException {
        if (this.rasterHandler == null) {
            this.rasterHandler = new GrassBinaryRasterReadHandler((File)this.input);
            this.rasterHandler.parseHeaderAndAccessoryFiles();
        }
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.ensureOpen();
        if (this.rasterHandler != null) {
            return this.rasterHandler.getRasterMapHeight();
        }
        return -1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.ensureOpen();
        if (this.rasterHandler != null) {
            return this.rasterHandler.getRasterMapWidth();
        }
        return -1;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return this.imagesMap.size();
    }

    @Override
    public synchronized Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.ensureOpen();
        this.csm = this.rasterHandler.getSampleModel();
        this.ccmdl = PlanarImage.createColorModel((SampleModel)this.csm);
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        if (this.imageType == null) {
            this.imageType = new ImageTypeSpecifier(this.ccmdl, this.csm);
            l.add(this.imageType);
        }
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.ensureOpen();
        if (this.metadata == null) {
            this.metadata = new GrassBinaryImageMetadata(this.rasterHandler);
        }
        return this.metadata;
    }

    public void setMonitor(ProgressListener monitor) {
        this.monitor = monitor;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param, boolean useSubSamplingAsRequestedRowcols, boolean castDoubleToFloating, ProgressListener monitor) throws IOException {
        this.useSubSamplingAsRequestedRowcols = useSubSamplingAsRequestedRowcols;
        this.castDoubleToFloating = castDoubleToFloating;
        this.monitor = monitor;
        return this.read(imageIndex, param);
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.ensureOpen();
        if (this.hasListeners) {
            this.clearAbortRequest();
            this.processImageStarted(0);
        }
        Raster readRaster = this.readRaster(imageIndex, param);
        this.csm = this.rasterHandler.getSampleModel();
        this.ccmdl = PlanarImage.createColorModel((SampleModel)this.csm);
        this.imageType = new ImageTypeSpecifier(this.ccmdl, this.csm);
        BufferedImage bi = new BufferedImage(this.ccmdl, (WritableRaster)readRaster, false, null);
        if (this.hasListeners) {
            if (this.rasterHandler.isAborting()) {
                this.processReadAborted();
            } else {
                this.processImageComplete();
            }
        }
        return bi;
    }

    @Override
    public BufferedImage read(int imageIndex) throws IOException {
        this.ensureOpen();
        return this.read(imageIndex, null);
    }

    @Override
    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        this.ensureOpen();
        try {
            return this.rasterHandler.readRaster(param, this.useSubSamplingAsRequestedRowcols, this.castDoubleToFloating, this.monitor);
        }
        catch (DataFormatException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public GrassBinaryRasterReadHandler getRasterReader() {
        return this.rasterHandler;
    }

    @Override
    public void dispose() {
        if (this.rasterHandler != null) {
            try {
                this.rasterHandler.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getCause());
            }
            this.rasterHandler = null;
        }
        super.dispose();
    }

    @Override
    public void reset() {
        this.dispose();
        super.setInput(null, false, false);
        this.rasterHandler = null;
        this.csm = null;
        this.imageType = null;
        this.metadata = null;
    }

    @Override
    public synchronized void abort() {
        if (this.rasterHandler != null) {
            this.rasterHandler.abort();
            this.rasterHandler = null;
        }
    }

    @Override
    protected synchronized boolean abortRequested() {
        return this.rasterHandler.isAborting();
    }
}

