/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster.metadata;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.core.GrassBinaryRasterReadHandler;
import org.geotools.gce.grassraster.metadata.GrassBinaryImageMetadataFormat;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Node;

public final class GrassBinaryImageMetadata
extends IIOMetadata {
    public static final String RULESSPLIT = "@@split@@";
    public static final String NO_DATA = "NO_DATA";
    public static final String NROWS = "NROWS";
    public static final String NCOLS = "NCOLS";
    public static final String XRES = "XRES";
    public static final String YRES = "YRES";
    public static final String SOUTH = "SOUTH";
    public static final String WEST = "WEST";
    public static final String NORTH = "NORTH";
    public static final String EAST = "EAST";
    public static final String CRS = "CRS";
    public static final String CATEGORIES_DESCRIPTOR = "categoriesDescriptor";
    public static final String COLOR_RULES_DESCRIPTOR = "colorRulesDescriptor";
    public static final String REGION_DESCRIPTOR = "regionDescriptor";
    public static final String nativeMetadataFormatName = "eu.hydrologis.jgrass.grassbinary.imageio.GrassBinaryImageMetadata_1.0";
    public static final String[] metadataFormatNames = new String[]{"eu.hydrologis.jgrass.grassbinary.imageio.GrassBinaryImageMetadata_1.0"};
    private double noData = Double.NaN;
    private double xRes = Double.NaN;
    private double yRes = Double.NaN;
    private int nCols = -1;
    private int nRows = -1;
    private double north = Double.NaN;
    private double south = Double.NaN;
    private double west = Double.NaN;
    private double east = Double.NaN;
    private List<String> colorRulesString = null;
    private List<String> categoriesString = null;
    private CoordinateReferenceSystem crs;

    public GrassBinaryImageMetadata(GrassBinaryRasterReadHandler rasterReader) {
        this();
        this.inizializeFromRaster(rasterReader);
    }

    public GrassBinaryImageMetadata() {
        super(false, nativeMetadataFormatName, "eu.hydrologis.jgrass.grassbinary.imageio.GrassBinaryImageMetadataFormat", null, null);
    }

    public GrassBinaryImageMetadata(int cols, int rows, double xRes, double yRes, double north, double south, double east, double west, double inNoData, List<String> colorRules, List<String> categories) {
        this();
        this.nCols = cols;
        this.nRows = rows;
        this.xRes = xRes;
        this.yRes = yRes;
        this.north = north;
        this.west = west;
        this.east = east;
        this.south = south;
        this.noData = inNoData;
        if (colorRules != null) {
            this.colorRulesString = colorRules;
        }
        if (categories != null) {
            this.categoriesString = categories;
        }
    }

    @Override
    public Node getAsTree(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
    }

    @Override
    public void reset() {
        this.west = Double.NaN;
        this.east = Double.NaN;
        this.south = Double.NaN;
        this.north = Double.NaN;
        this.yRes = Double.NaN;
        this.xRes = Double.NaN;
        this.nRows = -1;
        this.nCols = -1;
    }

    @Override
    public IIOMetadataFormat getMetadataFormat(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return new GrassBinaryImageMetadataFormat();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private void inizializeFromRaster(GrassBinaryRasterReadHandler rasterReader) {
        if (rasterReader != null) {
            JGrassRegion nativeRasterRegion = rasterReader.getNativeRasterRegion();
            this.nRows = nativeRasterRegion.getRows();
            this.nCols = nativeRasterRegion.getCols();
            this.xRes = nativeRasterRegion.getWEResolution();
            this.yRes = nativeRasterRegion.getNSResolution();
            this.north = nativeRasterRegion.getNorth();
            this.south = nativeRasterRegion.getSouth();
            this.east = nativeRasterRegion.getEast();
            this.west = nativeRasterRegion.getWest();
            this.noData = rasterReader.getNoData();
            try {
                this.colorRulesString = rasterReader.getColorRules(null);
                this.categoriesString = rasterReader.getCategories();
                this.crs = rasterReader.getCrs();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode node = new IIOMetadataNode("Compression");
        IIOMetadataNode subNode = new IIOMetadataNode("Lossless");
        subNode.setAttribute("value", "TRUE");
        node.appendChild(subNode);
        return node;
    }

    private Node getNativeTree() {
        int i;
        StringBuffer sB;
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode node = new IIOMetadataNode(REGION_DESCRIPTOR);
        node.setAttribute(NO_DATA, Double.toString(this.noData));
        node.setAttribute(NROWS, Integer.toString(this.nRows));
        node.setAttribute(NCOLS, Integer.toString(this.nCols));
        node.setAttribute(XRES, Double.toString(this.xRes));
        node.setAttribute(YRES, Double.toString(this.yRes));
        node.setAttribute(NORTH, Double.toString(this.north));
        node.setAttribute(SOUTH, Double.toString(this.south));
        node.setAttribute(EAST, Double.toString(this.east));
        node.setAttribute(WEST, Double.toString(this.west));
        node.setAttribute(CRS, this.crs.toWKT());
        root.appendChild(node);
        if (this.colorRulesString != null) {
            node = new IIOMetadataNode(COLOR_RULES_DESCRIPTOR);
            sB = new StringBuffer();
            for (i = 0; i < this.colorRulesString.size(); ++i) {
                if (i != 0) {
                    sB.append(RULESSPLIT);
                }
                sB.append(this.colorRulesString.get(i));
            }
            node.setAttribute(COLOR_RULES_DESCRIPTOR, sB.toString());
            root.appendChild(node);
        }
        if (this.categoriesString != null) {
            node = new IIOMetadataNode(CATEGORIES_DESCRIPTOR);
            sB = new StringBuffer();
            for (i = 0; i < this.categoriesString.size(); ++i) {
                if (i != 0) {
                    sB.append(RULESSPLIT);
                }
                sB.append(this.categoriesString.get(i));
            }
            node.setAttribute(CATEGORIES_DESCRIPTOR, sB.toString());
            root.appendChild(node);
        }
        return root;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GrassBinaryImageMetadata[");
        buffer.append("\n NORTH = ").append(this.north);
        buffer.append("\n SOUTH = ").append(this.south);
        buffer.append("\n EAST = ").append(this.east);
        buffer.append("\n WEST = ").append(this.west);
        buffer.append("\n XRES = ").append(this.xRes);
        buffer.append("\n YRES = ").append(this.yRes);
        buffer.append("\n NCOLS = ").append(this.nCols);
        buffer.append("\n NROWS = ").append(this.nRows);
        buffer.append("\n NO_DATA = ").append(this.noData);
        buffer.append("\n\ncategoriesString = ");
        for (String cat : this.categoriesString) {
            buffer.append("\n").append(cat);
        }
        buffer.append("\n colorRulesString = ");
        for (String colr : this.colorRulesString) {
            buffer.append("\n").append(colr);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public HashMap<String, String> toHashMap() {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put(WEST, String.valueOf(this.west));
        tmp.put(SOUTH, String.valueOf(this.south));
        tmp.put(EAST, String.valueOf(this.east));
        tmp.put(NORTH, String.valueOf(this.north));
        tmp.put(NROWS, String.valueOf(this.nRows));
        tmp.put(NCOLS, String.valueOf(this.nCols));
        tmp.put(XRES, String.valueOf(this.xRes));
        tmp.put(YRES, String.valueOf(this.yRes));
        tmp.put(NO_DATA, String.valueOf(this.noData));
        tmp.put(CRS, this.crs.toWKT());
        StringBuffer buffer = new StringBuffer();
        for (String cat : this.categoriesString) {
            buffer.append(cat).append(RULESSPLIT);
        }
        tmp.put(CATEGORIES_DESCRIPTOR, buffer.toString());
        buffer = new StringBuffer();
        for (String colr : this.colorRulesString) {
            buffer.append(colr).append(RULESSPLIT);
        }
        tmp.put(COLOR_RULES_DESCRIPTOR, buffer.toString());
        return tmp;
    }
}

