/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster.core;

import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.geotools.gce.grassraster.DummyProgressListener;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.core.CompressesRasterWriter;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

public class GrassBinaryRasterWriteHandler
implements Closeable {
    private ImageOutputStream imageOS = null;
    private ImageOutputStream imageNullFileOS = null;
    private Double noData = Double.NaN;
    private JGrassMapEnvironment writerGrassEnv = null;
    private long[] addressesOfRows;
    private long pointerInFilePosition = 0L;
    private final double[] range = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
    private int outputToDiskType = 2;
    private boolean jump = false;
    private boolean abortRequired;
    private JGrassRegion writeRegion = null;
    private ProgressListener monitor = new DummyProgressListener();

    public GrassBinaryRasterWriteHandler(File destMapset, String newMapName, ProgressListener monitor) {
        if (monitor != null) {
            this.monitor = monitor;
        }
        this.writerGrassEnv = new JGrassMapEnvironment(destMapset, newMapName);
        this.abortRequired = false;
    }

    public void writeRaster(RenderedImage renderedImage, int columns, int rows, double west, double south, double xRes, double yRes, double noDataValue) throws IOException {
        boolean hasListeners = false;
        if (!this.checkStructure()) {
            throw new IOException("Inconsistent output structure for grass map. Check your paths.");
        }
        this.imageOS = ImageIO.createImageOutputStream(this.writerGrassEnv.getFCELL());
        this.imageNullFileOS = ImageIO.createImageOutputStream(this.writerGrassEnv.getCELLMISC_NULL());
        double east = west + (double)columns * xRes;
        double north = south + (double)rows * yRes;
        JGrassRegion dataWindow = new JGrassRegion(west, east, south, north, rows, columns);
        this.createEmptyHeader(rows);
        if (hasListeners && this.abortRequired) {
            return;
        }
        CompressesRasterWriter crwriter = new CompressesRasterWriter(this.outputToDiskType, noDataValue, this.jump, this.range, this.pointerInFilePosition, this.addressesOfRows, dataWindow, this.monitor, this.writerGrassEnv.getMapName());
        crwriter.compressAndWrite(this.imageOS, this.imageNullFileOS, renderedImage);
        this.createUtilityFiles(dataWindow);
    }

    public JGrassRegion getWriteRegion() throws IOException {
        if (this.writeRegion == null) {
            File wind = this.writerGrassEnv.getWIND();
            this.writeRegion = new JGrassRegion(wind.getAbsolutePath());
        }
        return this.writeRegion;
    }

    public void setWriteRegion(JGrassRegion writeRegion) {
        this.writeRegion = writeRegion;
    }

    @Override
    public void close() throws IOException {
        if (this.imageOS != null) {
            this.imageOS.close();
            this.imageNullFileOS.close();
        }
    }

    private boolean checkStructure() {
        File mapset = this.writerGrassEnv.getMAPSET();
        String name = this.writerGrassEnv.getCELL().getName();
        String mapsetPath = mapset.getAbsolutePath();
        File ds = new File(mapsetPath + File.separator + "cats" + File.separator);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(mapsetPath + File.separator + "cell" + File.separator);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(mapsetPath + File.separator + "cell_misc" + File.separator);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(mapsetPath + File.separator + "cell_misc" + File.separator + name);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(mapsetPath + File.separator + "fcell" + File.separator);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(mapsetPath + File.separator + "cellhd" + File.separator);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(mapsetPath + File.separator + "colr" + File.separator);
        if (!ds.exists() && !ds.mkdir()) {
            return false;
        }
        ds = new File(mapsetPath + File.separator + "hist" + File.separator);
        return ds.exists() || ds.mkdir();
    }

    private void createEmptyHeader(int rows) throws IOException {
        this.addressesOfRows = new long[rows + 1];
        this.imageOS.write(4);
        for (int i = 0; i < rows + 1; ++i) {
            this.imageOS.writeInt(0);
        }
        this.addressesOfRows[0] = this.pointerInFilePosition = this.imageOS.getStreamPosition();
    }

    private void createUtilityFiles(JGrassRegion dataRegion) throws IOException {
        try (OutputStreamWriter catsWriter = new OutputStreamWriter(new FileOutputStream(this.writerGrassEnv.getCATS()));){
            catsWriter.write("# xyz categories\n#\n#\n 0.00 0.00 0.00 0.00");
        }
        try (OutputStreamWriter cellWriter = new OutputStreamWriter(new FileOutputStream(this.writerGrassEnv.getCELL()));){
            cellWriter.write("");
        }
        try (OutputStreamWriter cell_miscFormatWriter = new OutputStreamWriter(new FileOutputStream(this.writerGrassEnv.getCELLMISC_FORMAT()));){
            if (this.outputToDiskType * 4 == 8) {
                cell_miscFormatWriter.write("type: double\nbyte_order: xdr\nlzw_compression_bits: -1");
            } else {
                cell_miscFormatWriter.write("type: float\nbyte_order: xdr\nlzw_compression_bits: -1");
            }
        }
        try (OutputStreamWriter cell_miscQantWriter = new OutputStreamWriter(new FileOutputStream(this.writerGrassEnv.getCELLMISC_QUANT()));){
            cell_miscQantWriter.write("round");
        }
        try (FileOutputStream cell_miscRangeStream = new FileOutputStream(this.writerGrassEnv.getCELLMISC_RANGE());){
            ((OutputStream)cell_miscRangeStream).write(this.double2bytearray(this.range[0]));
            ((OutputStream)cell_miscRangeStream).write(this.double2bytearray(this.range[1]));
        }
        JGrassRegion tmp = this.getWriteRegion();
        this.createCellhd(tmp.getProj(), tmp.getZone(), dataRegion.getNorth(), dataRegion.getSouth(), dataRegion.getEast(), dataRegion.getWest(), dataRegion.getCols(), dataRegion.getRows(), dataRegion.getNSResolution(), dataRegion.getWEResolution(), -1, 1);
        try (OutputStreamWriter windFile = new OutputStreamWriter(new FileOutputStream(this.writerGrassEnv.getHIST()));){
            Date date = new Date();
            windFile.write(date + "\n");
            windFile.write(this.writerGrassEnv.getCELL().getName() + "\n");
            windFile.write(this.writerGrassEnv.getMAPSET().getAbsolutePath() + "\n");
            windFile.write(System.getProperty("user.name") + "\n");
            windFile.write("DCELL\n");
            windFile.write("\n\nCreated by imageio-ext enabled JGrass\n");
        }
    }

    private void createCellhd(int chproj, int chzone, double chn, double chs, double che, double chw, int chcols, int chrows, double chnsres, double chewres, int chformat, int chcompressed) throws IOException {
        StringBuffer data = new StringBuffer(512);
        data.append("proj:   " + chproj + "\n").append("zone:   " + chzone + "\n").append("north:   " + chn + "\n").append("south:   " + chs + "\n").append("east:   " + che + "\n").append("west:   " + chw + "\n").append("cols:   " + chcols + "\n").append("rows:   " + chrows + "\n").append("n-s resol:   " + chnsres + "\n").append("e-w resol:   " + chewres + "\n").append("format:   " + chformat + "\n").append("compressed:   " + chcompressed);
        try (OutputStreamWriter windFile = new OutputStreamWriter(new FileOutputStream(this.writerGrassEnv.getCELLHD()));){
            windFile.write(data.toString());
        }
    }

    private byte[] double2bytearray(double value) {
        long l = Double.doubleToLongBits(value);
        byte[] b = new byte[8];
        int shift = 56;
        int k = 0;
        while (k < 8) {
            b[k] = (byte)(l >>> shift);
            ++k;
            shift -= 8;
        }
        return b;
    }

    public void setNoData(double noData) {
        this.noData = noData;
    }

    public double getNoData() {
        return this.noData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem getCrs() throws IOException {
        String locationPath = this.writerGrassEnv.getLOCATION().getAbsolutePath();
        CoordinateReferenceSystem readCrs = null;
        String projWtkFilePath = locationPath + File.separator + "PERMANENT" + File.separator + "PROJ_INFO.WKT";
        File projWtkFile = new File(projWtkFilePath);
        if (projWtkFile.exists()) {
            StringBuffer wtkString = new StringBuffer();
            try (BufferedReader crsReader = new BufferedReader(new FileReader(projWtkFile));){
                String line = null;
                while ((line = crsReader.readLine()) != null) {
                    wtkString.append(line.trim());
                }
            }
            try {
                readCrs = CRS.parseWKT((String)wtkString.toString());
            }
            catch (FactoryException e) {
                throw new IOException(e.getLocalizedMessage());
            }
            return readCrs;
        }
        return null;
    }

    public void abort() {
        this.abortRequired = true;
    }

    public boolean isAborting() {
        return this.abortRequired;
    }
}

