/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster.core.color;

import java.awt.Color;
import java.util.List;

public class ColorRule {
    private float low = 0.0f;
    private float range = 0.0f;
    private byte[] catColor = null;
    private float rmul = 0.0f;
    private float gmul = 0.0f;
    private float bmul = 0.0f;

    public ColorRule(int cat, int r, int g, int b) {
        this.low = cat;
        this.range = 0.0f;
        this.catColor = new byte[]{(byte)r, (byte)g, (byte)b, -1};
    }

    public ColorRule(float cat0, int r0, int g0, int b0, float cat1, int r1, int g1, int b1) {
        if (cat1 > cat0) {
            this.low = cat0;
            this.range = cat1 - cat0;
            this.catColor = new byte[]{(byte)r0, (byte)g0, (byte)b0, -1};
            this.rmul = (float)(r1 - r0) / this.range;
            this.gmul = (float)(g1 - g0) / this.range;
            this.bmul = (float)(b1 - b0) / this.range;
        } else {
            this.low = cat1;
            this.range = cat0 - cat1;
            this.catColor = new byte[]{(byte)r1, (byte)g1, (byte)b1, -1};
            this.rmul = (float)(r0 - r1) / this.range;
            this.gmul = (float)(g0 - g1) / this.range;
            this.bmul = (float)(b0 - b1) / this.range;
        }
    }

    public int compare(float cat) {
        float diff = cat - this.low;
        if (diff < 0.0f) {
            return -1;
        }
        if (diff <= this.range) {
            return 0;
        }
        return 1;
    }

    public byte[] getColor(float cat) {
        float diff = cat - this.low;
        if (diff <= 0.0f) {
            return this.catColor;
        }
        if (diff > this.range) {
            return new byte[]{(byte)((int)(this.rmul * this.range) + this.catColor[0]), (byte)((int)(this.gmul * this.range) + this.catColor[1]), (byte)((int)(this.bmul * this.range) + this.catColor[2]), this.catColor[3]};
        }
        return new byte[]{(byte)((int)(this.rmul * diff) + this.catColor[0]), (byte)((int)(this.gmul * diff) + this.catColor[1]), (byte)((int)(this.bmul * diff) + this.catColor[2]), this.catColor[3]};
    }

    public float getLowCategoryValue() {
        return this.low;
    }

    public float getCategoryRange() {
        return this.range;
    }

    public String toString() {
        if (this.range == 0.0f) {
            return String.valueOf(this.low) + ":[" + (this.catColor[0] & 0xFF) + "," + (this.catColor[1] & 0xFF) + "," + (this.catColor[2] & 0xFF) + "," + (this.catColor[3] & 0xFF) + "]";
        }
        return String.valueOf(this.low) + "-" + String.valueOf(this.low + this.range) + ":[" + (this.catColor[0] & 0xFF) + "," + (this.catColor[1] & 0xFF) + "," + (this.catColor[2] & 0xFF) + "," + (this.catColor[3] & 0xFF) + "]-[" + ((int)(this.rmul * this.range) + this.catColor[0]) + "," + ((int)(this.gmul * this.range) + this.catColor[1]) + "," + ((int)(this.bmul * this.range) + this.catColor[2]) + "," + (this.catColor[3] & 0xFF) + "]";
    }

    public static void parseColorRule(String colorRule, List<Double> values, List<Color> colors) {
        String[] ruleSplit = colorRule.split(":");
        String valuesString = ruleSplit[0];
        int indexOf = valuesString.indexOf(45);
        String firstValueStr = valuesString.substring(0, indexOf);
        String secondValueStr = valuesString.substring(indexOf + 1, valuesString.length());
        values.add(Double.parseDouble(firstValueStr));
        values.add(Double.parseDouble(secondValueStr));
        String colorsString = ruleSplit[1];
        String[] colorsSplit = colorsString.split("\\]-\\[");
        String col1 = colorsSplit[0].substring(1);
        String col2 = colorsSplit[1].substring(0, colorsSplit[1].length() - 1);
        String[] rgba1 = col1.split(",");
        String[] rgba2 = col2.split(",");
        Color color1 = new Color(Integer.parseInt(rgba1[0]), Integer.parseInt(rgba1[1]), Integer.parseInt(rgba1[2]), Integer.parseInt(rgba1[3]));
        Color color2 = new Color(Integer.parseInt(rgba2[0]), Integer.parseInt(rgba2[1]), Integer.parseInt(rgba2[2]), Integer.parseInt(rgba2[3]));
        colors.add(color1);
        colors.add(color2);
    }
}

