/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster.core;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.zip.Deflater;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.geotools.gce.grassraster.DummyProgressListener;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

public class CompressesRasterWriter {
    private int outputToDiskType = 0;
    private double novalue = -9999.0;
    private boolean jump = false;
    private double[] range = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
    private long pointerInFilePosition = 0L;
    private long[] rowaddresses = null;
    private JGrassRegion dataWindow = null;
    private ProgressListener monitor = new DummyProgressListener();
    private final String mapName;

    public CompressesRasterWriter(int _outputToDiskType, double _novalue, boolean _jump, double[] _range, long _pointerInFilePosition, long[] _rowaddresses, JGrassRegion _dataWindow, ProgressListener monitor, String mapName) {
        this.outputToDiskType = _outputToDiskType;
        this.novalue = _novalue;
        this.jump = _jump;
        this.range = _range;
        this.pointerInFilePosition = _pointerInFilePosition;
        this.rowaddresses = _rowaddresses;
        this.dataWindow = _dataWindow;
        this.mapName = mapName;
        if (monitor != null) {
            this.monitor = monitor;
        }
    }

    public void compressAndWrite(ImageOutputStream theCreatedFile, ImageOutputStream theCreatedNullFile, RenderedImage renderedImage) throws IOException {
        int numberofbytes = this.outputToDiskType * 4;
        int dataWindowCols = this.dataWindow.getCols();
        int dataWindowRows = this.dataWindow.getRows();
        byte[] rowAsBytes = new byte[dataWindowCols * numberofbytes];
        ByteBuffer rowAsByteBuffer = ByteBuffer.wrap(rowAsBytes);
        int numberOfValuesPerRow = dataWindowCols;
        int rest = numberOfValuesPerRow % 8;
        int paddings = 0;
        if (rest != 0) {
            paddings = 8 - rest;
        }
        BitSet nullbits = new BitSet(numberOfValuesPerRow + paddings);
        int height = renderedImage.getHeight();
        int width = renderedImage.getWidth();
        RandomIter iterator = RandomIterFactory.create((RenderedImage)renderedImage, (Rectangle)new Rectangle(0, 0, width, height));
        int k = 0;
        this.monitor.started();
        this.monitor.setTask((InternationalString)new SimpleInternationalString("Writing map to disk: " + this.mapName));
        float progress = 0.0f;
        for (int i = 0; i < dataWindowRows; ++i) {
            for (int j = 0; j < dataWindowCols; ++j) {
                double value = iterator.getSampleDouble(j, i, 0);
                if (Double.isNaN(value) || value == this.novalue) {
                    if (numberofbytes == 8) {
                        rowAsByteBuffer.putDouble(0.0);
                    } else {
                        rowAsByteBuffer.putFloat(0.0f);
                    }
                    nullbits.set(k);
                    ++k;
                    continue;
                }
                if (value < this.range[0]) {
                    this.range[0] = value;
                }
                if (value > this.range[1]) {
                    this.range[1] = value;
                }
                if (numberofbytes == 8) {
                    rowAsByteBuffer.putDouble(value);
                } else {
                    rowAsByteBuffer.putFloat((float)value);
                }
                ++k;
            }
            int l = 0;
            byte[] bytearray = new byte[(numberOfValuesPerRow + paddings) / 8];
            for (int e = 0; e < (numberOfValuesPerRow + paddings) / 8; ++e) {
                bytearray[e] = 0;
                for (int f = 0; f < 8; ++f) {
                    if (nullbits.get(l)) {
                        int n = e;
                        bytearray[n] = (byte)(bytearray[n] + (byte)Math.pow(2.0, 7 - f));
                    }
                    ++l;
                }
            }
            theCreatedNullFile.write(bytearray);
            nullbits.clear();
            k = 0;
            byte[] output = new byte[rowAsBytes.length * 2];
            Deflater compresser = new Deflater();
            compresser.setInput(rowAsBytes);
            compresser.finish();
            int compressedDataLength = compresser.deflate(output);
            theCreatedFile.seek(this.pointerInFilePosition);
            theCreatedFile.write(49);
            theCreatedFile.write(output, 0, compressedDataLength);
            this.rowaddresses[i + 1] = this.pointerInFilePosition = theCreatedFile.getStreamPosition();
            rowAsByteBuffer.clear();
            this.monitor.progress(progress += 100.0f * (float)i / (float)dataWindowRows);
        }
        this.monitor.complete();
        theCreatedFile.seek(1L);
        for (long rowaddress : this.rowaddresses) {
            theCreatedFile.writeInt((int)rowaddress);
        }
    }

    public JGrassRegion getDataWindow() {
        return this.dataWindow;
    }

    public boolean isJump() {
        return this.jump;
    }

    public double getNovalue() {
        return this.novalue;
    }

    public int getOutputToDiskType() {
        return this.outputToDiskType;
    }

    public long getPointerInFilePosition() {
        return this.pointerInFilePosition;
    }

    public double[] getRange() {
        return this.range;
    }

    public long[] getRowaddresses() {
        return this.rowaddresses;
    }
}

