/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.opt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.opt.OptGraphable;

public class OptNode
extends OptGraphable
implements Node {
    private Edge[] m_edges;

    public OptNode() {
        this(0);
    }

    public OptNode(int degree) {
        this.m_edges = new Edge[degree];
    }

    @Override
    public void add(Edge e) {
        for (int i = 0; i < this.m_edges.length; ++i) {
            if (this.m_edges[i] != null) continue;
            this.m_edges[i] = e;
            return;
        }
    }

    @Override
    public void remove(Edge e) {
        throw new UnsupportedOperationException(this.getClass().getName() + "#remove(Edge)");
    }

    @Override
    public Edge getEdge(Node other) {
        for (Edge m_edge : this.m_edges) {
            if ((!m_edge.getNodeA().equals(this) || !m_edge.getNodeB().equals(other)) && (!m_edge.getNodeB().equals(this) || !m_edge.getNodeA().equals(other))) continue;
            return m_edge;
        }
        return null;
    }

    public List<Edge> getEdges(Node other) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge m_edge : this.m_edges) {
            if ((!m_edge.getNodeA().equals(this) || !m_edge.getNodeB().equals(other)) && (!m_edge.getNodeB().equals(this) || !m_edge.getNodeA().equals(other))) continue;
            edges.add(m_edge);
        }
        return edges;
    }

    public Edge[] getEdgeArray() {
        return this.m_edges;
    }

    public List<Edge> getEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge m_edge : this.m_edges) {
            edges.add(m_edge);
        }
        return edges;
    }

    public void setDegree(int degree) {
        this.m_edges = new Edge[degree];
    }

    @Override
    public int getDegree() {
        return this.m_edges.length;
    }

    public Iterator<Node> getRelated() {
        return new RelatedIterator(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setDegree(in.readInt());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.getDegree());
    }

    public class RelatedIterator
    implements Iterator<Node> {
        private byte m_index = 0;
        private OptNode m_node;

        public RelatedIterator(OptNode node) {
            this.m_node = node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName() + "#remove()");
        }

        @Override
        public boolean hasNext() {
            return this.m_index < OptNode.this.m_edges.length;
        }

        @Override
        public Node next() {
            byte by = this.m_index;
            this.m_index = (byte)(by + 1);
            Edge e = OptNode.this.m_edges[by];
            return e.getNodeA().equals(this.m_node) ? e.getNodeB() : e.getNodeA();
        }
    }
}

