/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.opt;

import java.util.ArrayList;
import java.util.Iterator;
import org.geotools.graph.structure.DirectedEdge;
import org.geotools.graph.structure.DirectedNode;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.opt.OptDirectedNode;
import org.geotools.graph.structure.opt.OptGraphable;

public class OptDirectedEdge
extends OptGraphable
implements DirectedEdge {
    private OptDirectedNode m_in;
    private OptDirectedNode m_out;

    public OptDirectedEdge(OptDirectedNode in, OptDirectedNode out) {
        this.m_in = in;
        this.m_out = out;
    }

    @Override
    public DirectedNode getInNode() {
        return this.m_in;
    }

    @Override
    public DirectedNode getOutNode() {
        return this.m_out;
    }

    @Override
    public Node getNodeA() {
        return this.m_in;
    }

    @Override
    public Node getNodeB() {
        return this.m_out;
    }

    @Override
    public Node getOtherNode(Node node) {
        return node == this.m_in ? this.m_out : (node == this.m_out ? this.m_in : null);
    }

    @Override
    public void reverse() {
        throw new UnsupportedOperationException(this.getClass().getName() + "#reverse()");
    }

    @Override
    public int compareNodes(Edge other) {
        if (this.m_in.equals(other.getNodeA()) && this.m_out.equals(other.getNodeB())) {
            return 0;
        }
        if (this.m_in.equals(other.getNodeB()) && this.m_out.equals(other.getNodeA())) {
            return -1;
        }
        return 1;
    }

    @Override
    public Iterator<? extends Graphable> getRelated() {
        DirectedEdge[] edges;
        ArrayList<DirectedEdge> related = new ArrayList<DirectedEdge>(this.m_in.getDegree() + this.m_out.getDegree() - 2);
        for (DirectedEdge edge : edges = this.m_in.getInEdgeArray()) {
            related.add(edge);
        }
        for (DirectedEdge e : edges = this.m_in.getOutEdgeArray()) {
            if (e.equals(this) || e.getNodeA().equals(e.getNodeB())) continue;
            related.add(e);
        }
        block10: for (DirectedEdge e : edges = this.m_out.getInEdgeArray()) {
            switch (this.compareNodes(e)) {
                case -1: 
                case 0: {
                    continue block10;
                }
                case 1: {
                    related.add(e);
                }
            }
        }
        block11: for (DirectedEdge e : edges = this.m_out.getOutEdgeArray()) {
            switch (this.compareNodes(e)) {
                case -1: 
                case 0: {
                    continue block11;
                }
                case 1: {
                    if (e.getNodeA().equals(e.getNodeB())) continue block11;
                    related.add(e);
                }
            }
        }
        return related.iterator();
    }

    @Override
    public Iterator<? extends Graphable> getInRelated() {
        return new RelatedIterator(0);
    }

    @Override
    public Iterator<? extends Graphable> getOutRelated() {
        return new RelatedIterator(1);
    }

    public class RelatedIterator
    implements Iterator<Graphable> {
        public static final int IN = 0;
        public static final int OUT = 1;
        public static final int BOTH = 2;
        private int m_mode;
        private int m_index;
        private int m_n;

        public RelatedIterator(int mode) {
            this.m_mode = mode;
            this.m_index = 0;
            switch (this.m_mode) {
                case 0: {
                    this.m_n = OptDirectedEdge.this.m_in.getInDegree();
                    break;
                }
                case 1: {
                    this.m_n = OptDirectedEdge.this.m_out.getOutDegree();
                    break;
                }
                default: {
                    this.m_n = 0;
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName() + "#remove()");
        }

        @Override
        public boolean hasNext() {
            return this.m_index < this.m_n;
        }

        @Override
        public Graphable next() {
            switch (this.m_mode) {
                case 0: {
                    return OptDirectedEdge.this.m_in.getInEdgeArray()[this.m_index++];
                }
                case 1: {
                    return OptDirectedEdge.this.m_out.getOutEdgeArray()[this.m_index++];
                }
            }
            return null;
        }
    }
}

