/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ParseErrorHandler
extends DefaultHandler
implements Serializable {
    static final Logger LOGGER = Logging.getLogger(ParseErrorHandler.class);
    List<SAXParseException> m_parseErrors = new ArrayList<SAXParseException>();

    @Override
    public void error(SAXParseException e) throws SAXException {
        super.error(e);
        this.m_parseErrors.add(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        super.fatalError(e);
        this.m_parseErrors.add(e);
    }

    public void reset() {
        this.m_parseErrors.clear();
    }

    public boolean noErrors() {
        return this.m_parseErrors.isEmpty();
    }

    public void printErrors() {
        for (SAXParseException e : this.m_parseErrors) {
            LOGGER.severe(e.getMessage());
        }
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        for (SAXParseException e : this.m_parseErrors) {
            out.append(e.getMessage());
        }
        return out.toString();
    }
}

