/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MultiMap
implements Map,
Serializable {
    private Map m_map = null;
    private Class m_collectionClass;

    public MultiMap(Map map, Class collectionClass) {
        this.m_map = map;
        this.m_collectionClass = collectionClass;
    }

    public Object put(Object key, Object value) {
        Collection c = null;
        c = (Collection)this.m_map.get(key);
        if (c == null) {
            try {
                c = (Collection)this.m_collectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getClass().getName() + ": " + e.getMessage());
            }
            this.m_map.put(key, c);
        }
        c.add(value);
        return c;
    }

    public void putItems(Object key, Collection items) {
        this.m_map.put(key, items);
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    @Override
    public void clear() {
        this.m_map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object o : this.values()) {
            Collection c = (Collection)o;
            if (!c.contains(value)) continue;
            return true;
        }
        return false;
    }

    public Collection values() {
        return this.m_map.values();
    }

    public void putAll(Map t) {
        Iterator iterator = t.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set entrySet() {
        return this.m_map.entrySet();
    }

    public Set keySet() {
        return this.m_map.keySet();
    }

    public Object get(Object key) {
        Object obj = null;
        Object v = this.m_map.get(key);
        obj = v;
        if (v == null) {
            try {
                obj = this.m_collectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getClass().getName() + ": " + e.getMessage());
            }
            this.putItems(key, obj);
        }
        return obj;
    }

    public Collection getItems(Object key) {
        return (Collection)this.get(key);
    }

    public Object remove(Object key) {
        return this.m_map.remove(key);
    }
}

