/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.traverse.standard;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.basic.AbstractGraphIterator;

public class BreadthFirstTopologicalIterator
extends AbstractGraphIterator {
    private Queue<Graphable> m_queue;

    @Override
    public void init(Graph graph, GraphTraversal traversal) {
        this.m_queue = this.buildQueue(graph);
        graph.visitNodes(component -> {
            Node node = (Node)component;
            node.setCount(0);
            if (node.getDegree() < 2) {
                this.m_queue.add(node);
            }
            return 0;
        });
    }

    @Override
    public Graphable next(GraphTraversal traversal) {
        if (this.m_queue.isEmpty()) {
            return null;
        }
        return this.m_queue.remove();
    }

    @Override
    public void cont(Graphable current, GraphTraversal traversal) {
        Iterator<? extends Graphable> itr = current.getRelated();
        while (itr.hasNext()) {
            Node related = (Node)itr.next();
            if (traversal.isVisited(related)) continue;
            related.setCount(related.getCount() + 1);
            if (related.getDegree() - 1 != related.getCount()) continue;
            this.m_queue.add(related);
        }
    }

    @Override
    public void killBranch(Graphable current, GraphTraversal traversal) {
    }

    protected Queue<Graphable> buildQueue(Graph graph) {
        return new ArrayDeque<Graphable>(graph.getNodes().size());
    }
}

