/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.build.polygon;

import java.util.List;
import org.geotools.graph.build.GraphBuilder;
import org.geotools.graph.build.GraphGenerator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.quadtree.Quadtree;

public class PolygonGraphGenerator
implements GraphGenerator {
    Quadtree index;
    PolygonRelationship rel;
    GraphBuilder builder;

    public PolygonGraphGenerator(GraphBuilder builder, PolygonRelationship rel) {
        this.setGraphBuilder(builder);
        this.rel = rel;
        this.index = new Quadtree();
    }

    @Override
    public Graphable add(Object obj) {
        Node node = (Node)this.get(obj);
        if (node == null) {
            node = this.builder.buildNode();
            this.builder.addNode(node);
            node.setObject(obj);
            this.relate(node);
            this.index.insert(((Polygon)obj).getEnvelopeInternal(), (Object)node);
        }
        return node;
    }

    @Override
    public Graphable get(Object obj) {
        Polygon polygon = (Polygon)obj;
        return this.find(polygon);
    }

    @Override
    public Graphable remove(Object obj) {
        Node node = (Node)this.get(obj);
        if (node != null) {
            Polygon polygon = (Polygon)node.getObject();
            this.index.remove(polygon.getEnvelopeInternal(), (Object)node);
            this.builder.removeNode(node);
        }
        return node;
    }

    @Override
    public void setGraphBuilder(GraphBuilder builder) {
        this.builder = builder;
    }

    @Override
    public GraphBuilder getGraphBuilder() {
        return this.builder;
    }

    @Override
    public Graph getGraph() {
        return this.builder.getGraph();
    }

    protected Node find(Polygon polygon) {
        List close = this.index.query(polygon.getEnvelopeInternal());
        for (Object o : close) {
            Node node = (Node)o;
            Polygon p = (Polygon)node.getObject();
            if (!this.rel.equal(polygon, p)) continue;
            return node;
        }
        return null;
    }

    protected void relate(Node node) {
        Polygon polygon = (Polygon)node.getObject();
        List close = this.index.query(polygon.getEnvelopeInternal());
        for (Object o : close) {
            Node n = (Node)o;
            Polygon p = (Polygon)n.getObject();
            if (this.rel.equal(polygon, p) || !this.rel.related(polygon, p)) continue;
            Edge edge = this.builder.buildEdge(node, n);
            this.builder.addEdge(edge);
            this.builder.addEdge(edge);
        }
    }

    public static interface PolygonRelationship {
        public boolean related(Polygon var1, Polygon var2);

        public boolean equal(Polygon var1, Polygon var2);
    }
}

