/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.build.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.geotools.graph.build.GraphBuilder;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicEdge;
import org.geotools.graph.structure.basic.BasicGraph;
import org.geotools.graph.structure.basic.BasicNode;

public class BasicGraphBuilder
implements GraphBuilder {
    private Graph m_graph;
    private Set<Node> m_nodes = new HashSet<Node>();
    private Set<Edge> m_edges = new HashSet<Edge>();

    public BasicGraphBuilder() {
        this.m_graph = this.buildGraph();
    }

    @Override
    public Node buildNode() {
        return new BasicNode();
    }

    @Override
    public Edge buildEdge(Node nodeA, Node nodeB) {
        return new BasicEdge(nodeA, nodeB);
    }

    @Override
    public void addNode(Node node) {
        this.m_nodes.add(node);
    }

    @Override
    public void addEdge(Edge edge) {
        edge.getNodeA().add(edge);
        if (!edge.getNodeA().equals(edge.getNodeB())) {
            edge.getNodeB().add(edge);
        }
        this.m_edges.add(edge);
    }

    @Override
    public void removeNode(Node node) {
        ArrayList<? extends Edge> toRemove = new ArrayList<Edge>(node.getEdges());
        this.removeEdges(toRemove);
        this.m_nodes.remove(node);
    }

    @Override
    public void removeNodes(Collection nodes) {
        for (Object node : nodes) {
            Node n = (Node)node;
            this.removeNode(n);
        }
    }

    @Override
    public void removeEdge(Edge edge) {
        edge.getNodeA().remove(edge);
        edge.getNodeB().remove(edge);
        this.m_edges.remove(edge);
    }

    @Override
    public void removeEdges(Collection edges) {
        for (Object edge : edges) {
            Edge e = (Edge)edge;
            this.removeEdge(e);
        }
    }

    @Override
    public Graph getGraph() {
        return this.m_graph;
    }

    @Override
    public Object clone(boolean deep) throws Exception {
        GraphBuilder builder = (GraphBuilder)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (deep) {
            builder.importGraph(this.getGraph());
        }
        return builder;
    }

    @Override
    public void importGraph(Graph g) {
        this.m_nodes = new HashSet<Node>(g.getNodes());
        this.m_edges = new HashSet<Edge>(g.getEdges());
        this.m_graph = this.buildGraph();
    }

    public Collection<Node> getNodes() {
        return this.m_nodes;
    }

    public Collection<Edge> getEdges() {
        return this.m_edges;
    }

    protected Graph buildGraph() {
        return new BasicGraph(this.m_nodes, this.m_edges);
    }
}

