/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraph;
import org.geotools.graph.util.delaunay.DelaunayNode;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class AutoClustUtils {
    public static List<Graph> findConnectedComponents(Collection<Node> nodes, Collection<Edge> edges) {
        ArrayList<Graph> components = new ArrayList<Graph>();
        ArrayList<Node> nodesVisited = new ArrayList<Node>();
        for (Node next : nodes) {
            if (nodesVisited.contains(next)) continue;
            ArrayList<Node> componentNodes = new ArrayList<Node>();
            ArrayList<Edge> componentEdges = new ArrayList<Edge>();
            AutoClustUtils.expandComponent(next, edges, componentNodes, componentEdges);
            nodesVisited.addAll(componentNodes);
            BasicGraph component = new BasicGraph(componentNodes, componentEdges);
            components.add(component);
        }
        return components;
    }

    private static void expandComponent(Node node, Collection<Edge> edges, Collection<Node> componentNodes, Collection<Edge> componentEdges) {
        if (!componentNodes.contains(node)) {
            componentNodes.add(node);
            List<Edge> adjacentEdges = AutoClustUtils.findAdjacentEdges(node, edges);
            componentEdges.addAll(adjacentEdges);
            for (Edge next : adjacentEdges) {
                Node additionalNode = next.getOtherNode(node);
                if (additionalNode == null) {
                    throw new RuntimeException("I tried to get the other node of this edge " + next + " but it doesn't have " + node);
                }
                AutoClustUtils.expandComponent(additionalNode, edges, componentNodes, componentEdges);
            }
            adjacentEdges.clear();
        }
    }

    public static List<Edge> findAdjacentEdges(Node node, Collection<Edge> edges) {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        for (Edge next : edges) {
            if (!next.getNodeA().equals(node) && !next.getNodeB().equals(node)) continue;
            ret.add(next);
        }
        return ret;
    }

    public static DelaunayNode[] featureCollectionToNodeArray(SimpleFeatureCollection fc) {
        int index = 0;
        int size = fc.size();
        DelaunayNode[] nodes = new DelaunayNode[size];
        try (SimpleFeatureIterator iter = fc.features();){
            while (iter.hasNext()) {
                SimpleFeature next = (SimpleFeature)iter.next();
                Geometry geom = (Geometry)next.getDefaultGeometry();
                Point centroid = geom instanceof Point ? (Point)geom : geom.getCentroid();
                DelaunayNode node = new DelaunayNode();
                node.setCoordinate(centroid.getCoordinate());
                node.setFeature(next);
                if (AutoClustUtils.arrayContains(node, nodes, index)) continue;
                nodes[index] = node;
                ++index;
            }
        }
        DelaunayNode[] trimmed = new DelaunayNode[index];
        for (int i = 0; i < index; ++i) {
            trimmed[i] = nodes[i];
        }
        return trimmed;
    }

    public static boolean arrayContains(DelaunayNode node, DelaunayNode[] nodes, int index) {
        boolean ret = false;
        boolean done = false;
        int i = 0;
        while (!done) {
            if (i < index) {
                done = ret = nodes[i].equals(node);
                ++i;
                continue;
            }
            done = true;
        }
        return ret;
    }
}

